/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <qregexp.h>

#include "encoderxml.h"

namespace BibTeX
{
    EncoderXML *encoderXML = NULL;

    static const struct EncoderXMLCharMapping
    {
        const char *regexp;
        unsigned int unicode;
        const char *latex;
    }
    charmappingdataxml[] = {
                               {"&amp;", 0x0026, "&amp;"},
                           };
    static const int charmappingdataxmlcount = sizeof( charmappingdataxml ) / sizeof( charmappingdataxml[ 0 ] ) ;

    EncoderXML::EncoderXML()
            : Encoder()
    {
        buildCharMapping();
    }


    EncoderXML::~EncoderXML()
    {
        // nothing
    }

    QString EncoderXML::decode( const QString &text )
    {
        QString result = text;

        for ( QValueList<CharMappingItem>::ConstIterator it = m_charMapping.begin(); it != m_charMapping.end(); ++it )
            result.replace( ( *it ).regExp, ( *it ).unicode );

        return result;
    }

    QString EncoderXML::encode( const QString &text )
    {
        QString result = text;

        for ( QValueList<CharMappingItem>::ConstIterator it = m_charMapping.begin(); it != m_charMapping.end(); ++it )
            result.replace( ( *it ).unicode, ( *it ).latex );

        return result;
    }

    QString EncoderXML::decodeSpecialized( const QString &text, const EntryField::FieldType /* fieldType */ )
    {
        return decode( text );
    }

    QString EncoderXML::encodeSpecialized( const QString &text, const EntryField::FieldType  /* fieldType */ )
    {
        return encode( text );
    }

    void EncoderXML::buildCharMapping()
    {
        for ( int i = 0; i < charmappingdataxmlcount; i++ )
        {
            CharMappingItem charMappingItem;
            charMappingItem.regExp = QRegExp( charmappingdataxml[ i ].regexp );
            charMappingItem.unicode = QChar( charmappingdataxml[ i ].unicode );
            charMappingItem.latex = QString( charmappingdataxml[ i ].latex );
            m_charMapping.append( charMappingItem );
        }
    }

    EncoderXML *EncoderXML::currentEncoderXML()
    {
        if ( encoderXML == NULL )
            encoderXML = new EncoderXML();

        return encoderXML;
    }

}
