/***************************************************************************
                         script.h  - manage a script
                         -------------------
    begin                : Sun Jul 27 2003
    copyright            : (C) 2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SCRIPT_H__
#define __SCRIPT_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>

#include <kconfig.h>
#include <klistview.h>

class AuthMethod {
  public:
    QString method, path;
};

class GuiData {
public:
  GuiData();

  QString address, port, pidfile;
  int maxclients, clientsperip;
  QString pureftpd, pureftpwho, puremrtginfo,
          pureauthd, purequotacheck, pureuploadscript,
          purepw, purepwconvert, purestatsdecode;
  QValueList<AuthMethod> authlist;
  int authtype;
  bool anonlogin, allowmkdir, ftpuserdeny, denyupload,
       anonreaddotfiles, nonanonlogin, readdotfiles,
       writedotfiles, restrictedip;
  QString loginip;
  bool disablechmod, usechrootall, usechroot, useuidlogin;
  int chrootgid, uidlogin, idletime, maxfiles, maxdepth,
      filesumask, dirsumask, debug;
  bool usesyslog, logpid, usefilelog, resolve;
  int facility, logformat;
  QString pathlog;
  bool useportrange, usequota, usedisklimit, useloadlimit;
  int portlow, porthigh, quotamaxfiles, quotamaxsize,
      diskpercent, grpbandwidth, bandupload, banddownload,
      grpratio, ratioupload, ratiodownload;
  double systemload;
  bool onlyipv4, activeftp, usepassiveip, useuploadscript,
       allowresume, createhomedir, usefortunes,
       neveroverwrite, norename, customerproof, enableworkarounds,
       fxpeveryone, fxpnonanonym;
  QString passiveip, fortunesfile;
};


class ScriptItem {

public:
    ScriptItem() : m_id(QString::null), m_title(QString::null), m_description(QString::null),
                   m_outputfile(QString::null), m_outputfilemode(0), m_scriptfile(QString::null),
                   m_templateid(QString::null),
                   m_changed(false), m_li(0L)
                   {}
    ScriptItem(const ScriptItem &item) :
                   m_id(item.m_id), m_title(item.m_title), m_description(item.m_description),
                   m_outputfile(item.m_outputfile), m_outputfilemode(item.m_outputfilemode),
                   m_scriptfile(item.m_scriptfile),
                   m_templateid(item.m_templateid),
                   m_guidata(item.m_guidata), m_changed(item.m_changed),
                   m_li(item.m_li)
                   {}
    ScriptItem(const QString &id, const QString &title, const QString &description,
               const QString &outputfile, int outputfilemode, const QString &scriptfile,
               const QString &templateid,
               GuiData guidata, bool changed) :
               m_id(id), m_title(title), m_description(description),
               m_outputfile(outputfile), m_outputfilemode(outputfilemode),
               m_scriptfile(scriptfile),
               m_templateid(templateid),
               m_guidata(guidata), m_changed(changed)
               {}

    QString id();
    QString title();
    QString description();
    QString outputfile();
    int outputfilemode();
    QString scriptfile();
    QString templateid();
    bool isChanged();
    GuiData guidata();

    void setId(const QString &t);
    void setTitle(const QString &t);
    void setDescription(const QString &t);
    void setOutputFile(const QString &t);
    void setOutputFileMode(int t);
    void setScriptFile(const QString &t);
    void setTemplateId(const QString &t);
    void setChanged(bool t);
    void setGuiData(const GuiData t);
    KListViewItem *li();
    void setLi(KListViewItem *t);

private:
    QString m_id, m_title, m_description, m_outputfile;
    int m_outputfilemode;
    QString m_scriptfile, m_templateid;
    GuiData m_guidata;
    bool m_changed;
    KListViewItem *m_li;
};

typedef QMap<QString,ScriptItem> ScriptItemMap;
typedef ScriptItemMap::Iterator ScriptItemIterator;

class Script {
  public:
    enum IOStatus {
        LoadOk,       // the script was successfully loaded in the m_map
        SaveOk,       // the script was successfully saved on disk
        ParseError,   // there was an error parsing XML script file
        OpenError,    // error while trying to open the script file
        ReadError,    // error during reading the script file
        WriteError,   // error during writing the script file
        DataError     // invalid data found in the XML script file
    };
    enum AuthMethodOption {
      NoPath,         // the authentication method have no associated path
      WithPath        // the authentication method must have associated path with it
    };

    Script();
    ScriptItemMap& map();
    IOStatus load(ScriptItem &i, const QString &scriptfile, QString &readid);
    void loadAll();
    IOStatus save(ScriptItem &item);
    void saveAll();
    void clear();
    ScriptItemIterator begin();
    ScriptItemIterator end();
    int count();
    QMap<QString,AuthMethodOption> authMethods() const;

  private:
    ScriptItemMap m_map;
    QMap<QString,AuthMethodOption> m_authmethods;
};

#endif
