/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSANNOTATABLE_H
#define DBUSANNOTATABLE_H

#include <qmap.h>
#include <qstring.h>
#include <qdom.h>

#include "dbusexceptions.h"
#include "dbusitem.h"

class QWidget;

/**
 * All DBus items which can be annotated should inherit from this.
 */
class DBusAnnotatable : public DBusItem {
public:
    DBusAnnotatable(
      QListViewItem * parent,
      QString const & text1,
      QString const & text2
    );

    DBusAnnotatable(
      QListView * parent,
      QString const & text1,
      QString const & text2
    );

    virtual ~DBusAnnotatable();

protected:
    /**
     * Add annotation contained under @a elem to this object.
     * @param elem XML representation of an annotation,
     *             according to D-BUS spec.
     */
    void addAnnotation( QDomElement const & elem )
      throw ( QDBusXmlError );

    /**
     * Add labels for annotations on this item.
     */
    void addAnnotationInfo( QWidget * widget ) const;

    /// Map from annotation name to value
    QMap< QString, QString > m_annotations;

private:
    /// Not implemented.
    DBusAnnotatable( DBusAnnotatable const & other );

    /// Not implemented.
    const DBusAnnotatable & operator=( DBusAnnotatable const & other );
};

#endif
