/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSOBJECT_H
#define DBUSOBJECT_H

#include "dbusexceptions.h"
#include "dbusitem.h"

class QDBusProxy;

/**
 * Representation of a DBus object.
 */
class DBusObject : public DBusItem
{
public:
    /**
     * @param parent Parent QListViewItem
     * @param elem  QDomElement representing this object as returned
     *              by org.freedesktop.DBus.Introspectable.Introspect.
     * @param connection    D-BUS connection to be used for purposes of
     *                      introspection (if necessary)
     */
    DBusObject(
      QListViewItem * parent,
      QDomElement const & elem,
      QDBusProxy * proxy
    )
    throw( QDBusSendError, QDBusXmlError );

    ~DBusObject();

    /**
     * @see DBusItem::widget
     */
    QWidget * widget( QWidget * parent ) const;


private:
    class Private; Private * d;

    /// Not implemented.
    DBusObject( DBusObject const & other );

    /// Not implemented.
    const DBusObject & operator=( DBusObject const & other);
};

#endif
