%define name pwmanager
%define version 1.2.4
%define release 0

Summary: KDE password manager
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Vendor: Michael Buesch <mbuesch@freenet.de>
Url: http://passwordmanager.sourceforge.net
Packager: Michael Buesch <mbuesch@freenet.de>
Group: Office
Source: %{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}

%description
With PwManager you can easily manage your passwords.
PwManager saves your passwords blowfish-encrypted in one file, so you have to remember only one master-password instead of all. Instead of the master-password you can use a chipcard, so you don't have to remember any password to access the list. It's able to import and export KPasman and GPasman files, such as plain-text files. It has a KWallet emulation layer, so it's able to communicate with every KWallet based application.

%prep
%setup
if [ "`kde-config --prefix`" ]; then
	CONFIGURE_PREFIX="`kde-config --prefix`"
elif [ "${KDEDIR}" ]; then
	CONFIGURE_PREFIX="${KDEDIR}"
elif [ -d "/opt/kde" ]; then
	CONFIGURE_PREFIX="/opt/kde"
elif [ -d "/opt/kde3" ]; then
	CONFIGURE_PREFIX="/opt/kde3"
else
	CONFIGURE_PREFIX="/usr"
fi
./configure --prefix="${CONFIGURE_PREFIX}" --enable-final

%build
# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
	numprocs=1
fi

make -j$numprocs

%install
make install DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > /var/tmp/file.list.%{name}
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >>  /var/tmp/file.list.%{name}
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >>  /var/tmp/file.list.%{name}

%clean
rm -rf $RPM_BUILD_ROOT/*
rm -rf $RPM_BUILD_DIR/%{name}-%{version}
rm -rf /var/tmp/file.list.%{name}

%files -f /var/tmp/file.list.%{name}
