/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGURATION_31COMPAT_H
#define CONFIGURATION_31COMPAT_H

#include "pwmexception.h"

#include <qsize.h>
#include <qfont.h>
#include <qstring.h>

class KConfig;

/** This class is the compatibility layer for
  * running the new KDE-3.2 Configuration interface on KDE-3.1.
  * We have to keep this class in sync with the real configuration
  * interface.
  */
class Configuration_31compat
{
public:
	Configuration_31compat();
	~Configuration_31compat();

	static Configuration_31compat * obj()
		{
			PWM_ASSERT(_obj);
			return _obj;
		}
	static void init()
		{
			PWM_ASSERT(!_obj);
			_obj = new Configuration_31compat;
		}
	static void cleanup()
			{ delete_ifnot_null(_obj); }


	/** Read the configuration from the file.
	  * Normally this function has not to be called manually.
	  *
	  * This function is a NOP in KDE-3.1 compatibility layer.
	  */
	void readConfig()
			{ }
	/** Write the configuration to the file.
	  * Normally this function has not to be called manually.
	  *
	  * This function is a NOP in KDE-3.1 compatibility layer.
	  */
	void writeConfig()
			{ }
	/** reset the whole configuration to its defaults.
	  *
	  * This function is a NOP in KDE-3.1 compatibility layer.
	  * It should not be, but it is. :)
	  */
	void resetConfig()
			{ }
	/** show the configuration window */
	bool showConfWnd(QWidget *parent);

public:
	/* functions for reading the configuration settings */
	/* GLOBAL */
	QString confGlobAutoStart();
	QString confGlobBrowserCommand();
	QString confGlobXtermCommand();
	QFont confGlobEntryFont();
	int confGlobPwTimeout();
	int confGlobLockTimeout();
	int confGlobCompression();
	int confGlobFilePermissions();
	int confGlobMinimizeLock();
	bool confGlobUnlockOnOpen();
	bool confGlobTray();
	bool confGlobMakeFileBackup();
	bool confGlobAutostartDeepLocked();
	bool confGlobAutoDeepLock();
	bool confGlobKwalletEmu();
	bool confGlobNewEntrLockStat();
	bool confGlobCanExecAsRoot();
	bool confGlobBase64Storage();
	/* WND */
	QSize confWndMainWndSize();
	int confWndMainViewStyle();
	bool confWndAutoMinimizeOnStart();
	bool confWndClose();

public:
	/* functions for writing the configuration settings */
	/* GLOBAL */
	void confGlobAutoStart(const QString &e);
	void confGlobBrowserCommand(const QString &e);
	void confGlobXtermCommand(const QString &e);
	void confGlobEntryFont(const QFont &e);
	void confGlobPwTimeout(int e);
	void confGlobLockTimeout(int e);
	void confGlobCompression(int e);
	void confGlobFilePermissions(int e);
	void confGlobMinimizeLock(int e);
	void confGlobUnlockOnOpen(bool e);
	void confGlobTray(bool e);
	void confGlobMakeFileBackup(bool e);
	void confGlobAutostartDeepLocked(bool e);
	void confGlobAutoDeepLock(bool e);
	void confGlobKwalletEmu(bool e);
	void confGlobNewEntrLockStat(bool e);
	void confGlobCanExecAsRoot(bool e);
	void confGlobBase64Storage(bool e);
	/* WND */
	void confWndMainWndSize(const QSize &e);
	void confWndMainViewStyle(int e);
	void confWndAutoMinimizeOnStart(bool e);
	void confWndClose(bool e);

protected:
	/** static instance of this class returned by obj() */
	static Configuration_31compat *_obj;
	/** configuration object */
	KConfig *conf;
};

#ifdef Configuration
# error "Configuration already defined!"
#endif
#define Configuration	Configuration_31compat

#endif
