/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "configwndimpl.h"
#include "pwm.h"
#include "configuration.h"

#include <qfileinfo.h>
#include <qlineedit.h>

#include <kstandarddirs.h>
#include <kfiledialog.h>
#include <klocale.h>

#include <stdlib.h>
#include <stdio.h>


ConfigWndImpl::ConfigWndImpl()
{
}

ConfigWndImpl::~ConfigWndImpl()
{
}

void ConfigWndImpl::okButton_slot()
{
	done(0);
}

void ConfigWndImpl::cancelButton_slot()
{
	done(1);
}

void ConfigWndImpl::browseAutoStButton_slot()
{
	QString path(KFileDialog::getOpenFileName(QString::null,
						  i18n("*.pwm|PwManager Password file\n"
						       "*|All files"), this));
	if (path != QString::null)
		autoStartLineEdit->setText(path);
}

void ConfigWndImpl::selEntrFontButton_slot()
{
	bool ok;
	QFont fnt = QFontDialog::getFont(&ok, currentEntryFont, this);
	if (!ok)
		return;
	currEntrFont->setFont(fnt);
	currEntrFont->setText(fnt.family());
	currentEntryFont = fnt;
}

int ConfigWndImpl::getFilePermissions()
{
	char octalDigits[] = "01234567";
	bool isOctal;
	QString permString(permissionLineEdit->text());
	int i, j, length = permString.length();
	if (length != 3) {
		printWarn("Wrong permission string length! Please enter "
			  "the string like the following example: 600");
		return CONF_DEFAULT_FILEPERMISSIONS;
	}
	for (i = 0; i < length; ++i) {
		isOctal = false;
		for (j = 0; j < 8; ++j) {
			if (permString.at(i) == octalDigits[j]) {
				isOctal = true;
				break;
			}
		}
		if (!isOctal) {
			printWarn("CONFIG: File-permissions: This is "
				  "not an octal number ");
			return CONF_DEFAULT_FILEPERMISSIONS;
		}
	}

	int ret = strtol(permString.latin1(), 0, 8);
	if (ret == 0) {
		/* either an error occured, or the user did really type 000 */
		printWarn("CONFIG: File-permissions: Hm, either conversion error, "
			  "or you really typed 000. 8-)");
		return CONF_DEFAULT_FILEPERMISSIONS;
	}
	return ret;
}

void ConfigWndImpl::setFilePermissions(int perm)
{
	char tmpBuf[30];
	sprintf(tmpBuf, "%o", perm);
	permissionLineEdit->setText(tmpBuf);
}

#include "configwndimpl.moc"
