/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "genpasswd_extern.h"
#include "pwmexception.h"

#include <qstringlist.h>
#include <qregexp.h>

#include <klocale.h>


GenPasswd_extern::GenPasswd_extern()
{
	proc.setUseShell(true);
	connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)),
		this, SLOT(receivedStdout(KProcess *, char *, int)));
	connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)),
		this, SLOT(receivedStderr(KProcess *, char *, int)));
}

GenPasswd_extern::~GenPasswd_extern()
{
}

QString GenPasswd_extern::gen()
{
	PWM_ASSERT(recStdout.isEmpty());
	PWM_ASSERT(recStderr.isEmpty());
	PWM_ASSERT(proc.args().isEmpty());
	PWM_ASSERT(error.isEmpty());
	proc << cmd;
	proc.start(KProcess::Block, KProcess::All);
	cleanOutput();
	int exitStatus = proc.exitStatus();
	if (exitStatus || !proc.normalExit() ||
	    (recStdout.isEmpty() && !recStderr.isEmpty())) {
		error = i18n("<QT><B>Execution failure (Exit Status: %1)</B><BR>"
			     "<B>Command:</B> <CODE>%2</CODE><BR>")
		        .arg(QString::number(exitStatus)).arg(cmd);
		if (!recStderr.isEmpty()) {
			if (recStderr.length() > 300) {
				recStderr.truncate(300);
				recStderr += i18n("<BR><SMALL>...[Error message truncated]</SMALL>");
			}
			error += i18n("<B>Error message:</B><BR><I><PRE>%1</PRE></I>")
				 .arg(recStderr);
		}
		error += "</QT>";
		return QString();
	}
	return recStdout;
}

void GenPasswd_extern::cleanOutput()
{
	// remove trailing newline
	if (recStdout.endsWith("\n"))
		recStdout.truncate(recStdout.length() - 1);
	if (recStderr.endsWith("\n"))
		recStderr.truncate(recStderr.length() - 1);
}

void GenPasswd_extern::receivedStdout(KProcess *_proc, char *buffer, int buflen)
{
	PWM_ASSERT(_proc == &proc);
	PARAM_UNUSED(_proc);
	recStdout += QString::fromAscii(buffer, buflen);
}

void GenPasswd_extern::receivedStderr(KProcess *_proc, char *buffer, int buflen)
{
	PWM_ASSERT(_proc == &proc);
	PARAM_UNUSED(_proc);
	recStderr += QString::fromAscii(buffer, buflen);
}

#include "genpasswd_extern.moc"
