/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004, 2005  by Michael Buesch                     *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_GLOBALSTUFF_H_
#define PWMANAGER_GLOBALSTUFF_H_

#include "config.h"
#include "compiler.h"

#include <string>
#include <sstream>

#ifdef PROG_NAME
# undef PROG_NAME
#endif
#ifdef PROG_NICKNAME
# undef PROG_NICKNAME
#endif
#ifdef PACKAGE_NAME
# undef PACKAGE_NAME
#endif
#ifdef PACKAGE_VER
# undef PACKAGE_VER
#endif
#include "../pwmanagerversion.h"

#ifdef CONFIG_DEBUG
# define PWM_DEBUG
#else
# undef PWM_DEBUG
#endif

#ifdef QT_MAKE_VERSION
# undef QT_MAKE_VERSION
#endif
#define QT_MAKE_VERSION(a,b,c)	(((a) << 16) | ((b) << 8) | (c))

/** remove "unused parameter" warnings */
#ifdef PARAM_UNUSED
# undef PARAM_UNUSED
#endif
#define PARAM_UNUSED(x)	(void)x

/** return the number of elements in an array */
#ifdef array_size
# undef array_size
#endif
#define array_size(x)	(sizeof(x) / sizeof((x)[0]))

#include <qstring.h>

class QWidget;

class PwMGlobal
{
private:
	PwMGlobal() { }

public:
	/** convert a byte stream to human readable HEX-notation. */
	static QString humanReadableHex(const QByteArray &d);
	/** Feature not available for "root" */
	static bool rootAlertMsgBox(QWidget *parent);
};

/** convert something to string using ostringstream */
template <class T> inline
std::string tostr(const T &t)
{
	std::ostringstream s;
	s << t;
	return s.str();
}

/** delete the memory and NULL the pointer */
template<class T> inline
void delete_and_null(T *&p)
{
	delete p;
	p = 0;
}
/** delete the memory if the pointer isn't a NULL pointer */
template<class T> inline
void delete_ifnot_null(T *&p)
{
	if (p)
		delete_and_null(p);
}

template<class T> inline
void delete_and_null_array(T *&p)
{
	delete [] p;
	p = 0;
}

template<class T> inline
void delete_ifnot_null_array(T *&p)
{
	if (p)
		delete_and_null_array(p);
}

#endif // PWMANAGER_GLOBALSTUFF_H_
