/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __PARAMWND_H
#define __PARAMWND_H

#include <qwidget.h>
#include <qmap.h>
#include <qcstring.h>
#include <qstring.h>
#include <qvbox.h>

#include <kwallet.h>


class ParamWnd : public QWidget
{
	Q_OBJECT
public:
	ParamWnd(const char *_funcId,
		 QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~ParamWnd();

	QString open_QString(const char *paramId);
	QCString open_QCString(const char *paramId);
	bool open_bool(const char *paramId);
	KWallet::Wallet::OpenType open_OpenType(const char *paramId);
	KWallet::Wallet::EntryType open_EntryType(const char *paramId);
	WId open_WId(const char *paramId);
	QByteArray open_QByteArray(const char *paramId);
	QMap<QString,QString> open_QMap_QString_QString(const char *paramId);

protected:
	const char *funcId;
	QVBox *vbox;
	bool okQuit;

protected:
	void closeEvent(QCloseEvent *e);
	void resizeEvent(QResizeEvent *);
	void addButtons();
	void wait();

protected slots:
	void okButton();
};

#endif // __PARAMWND_H
