/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef KWALLETIF_H
#define KWALLETIF_H

#include "globalstuff.h"

#include <qwidget.h>
#include <qstringlist.h>

#include <kwallet.h>
using namespace KWallet;

class PwMDoc;

/** KWallet interface code */
class KWalletIf : public QObject
{
	Q_OBJECT
public:
	KWalletIf(QWidget *_parentView);
	~KWalletIf();

	bool kwalletImport(PwMDoc *doc);
	bool kwalletExport(PwMDoc *doc);

protected:
	/** ask the user which wallet to open and do that */
	bool openWallet();
	/** ask the user which folder to select */
	bool selectFolder();
	/** ask the user which entrie(s) to import */
	bool selectEntries();
	/** delete the current wallet object (if open) */
	void delWalletObj();
	/** do import the data. (wallet has to be initialized) */
	bool doImport(PwMDoc *doc);
	/** do export the data. */
	bool doExport(PwMDoc *doc);

protected:
	/** pointer to current wallet */
	Wallet *wallet;
	/** pointer to the parent view widget */
	QWidget *parentView;
	/** currently selected entrie(s) */
	QStringList curEntries;
	/** importing data? (If false, we are exporting) */
	bool importing;
};

#endif
