/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004 by Michael Buesch                            *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_WAITWND_H_
#define PWMANAGER_WAITWND_H_

#include <qdialog.h>

class QLabel;
class QPushButton;
class QVBoxLayout;
class QCloseEvent;

/** window to ask the user to wait */
class WaitWnd : public QDialog
{
	Q_OBJECT

public:
	WaitWnd(QString caption, QString _staticText,
		bool showCancelButton, bool showGenericText,
		QWidget *parent = 0, const char *name = 0,
		bool modal = FALSE, WFlags f = 0);
	~WaitWnd();

	void setGenericText(const QString &text);
	void close();

signals:
	void closing();

protected slots:
	void cancelButton_slot();

protected:
	void closeEvent(QCloseEvent *e);

protected:
	QVBoxLayout *layout;
	QLabel *staticText;
	QLabel *genericText;
	QPushButton *cancelButton;
};

#endif // PWMANAGER_WAITWND_H_
