#include "nex.h"
#include "noatunplugin.h"

#include <k3process.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kstandarddirs.h>

extern "C"
{
Plugin *create_plugin()
{
	KGlobal::locale()->insertCatalog("nexscope");
	return new NexPlugin();
}
}


NexPlugin::NexPlugin()
{
	connect(&process, SIGNAL(processExited(K3Process *)), this, SLOT(processExited(K3Process *)));
}

NexPlugin::~NexPlugin()
{
	process.kill();
}

void NexPlugin::init()
{
	process << KStandardDirs::findExe("nexscope.bin");

	// Note that process.start() will fail if findExe fails, so there's no real need
	// for two separate checks.
	if(!process.start(K3Process::NotifyOnExit, (K3Process::Communication)(K3Process::Stdin | K3Process::Stdout)))
	{
		KMessageBox::error(0, i18n("Unable to start noatunNex. Check your installation."));
		unload();
	}

}

void NexPlugin::processExited(K3Process *)
{
	unload();
}

#include  "noatunplugin.moc"

