/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
// Author: Damyan Pepper
//         Toivo Pedaste
//
// See kpackage.h for more information.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/


#include <kactioncollection.h>
#include <QDir>
#include <QLabel>
#include <q3frame.h>
//Added by qt3to4:
#include <QDragEnterEvent>
#include <QResizeEvent>
#include <QDropEvent>
#include <QCloseEvent>
#include <Q3PtrList>

#include <kdebug.h>
#include <kxmlguifactory.h>
#include <kapplication.h>
#include <kfiledialog.h>
#include <qprogressbar.h>
#include <kurl.h>
#include <kapplication.h>
#include <krecentfilesaction.h>
#include <kaction.h>
#include <klocale.h>
#include <kinputdialog.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kstandardaction.h>
#include <kedittoolbar.h>
#include <kstandardshortcut.h>
#include "kpackage.h"
#include "managementWidget.h"
#include "pkgOptions.h"
#include "kio.h"
#include "findf.h"
#include "search.h"
#include "options.h"
#include "cache.h"

extern Opts *opts;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
KPKG::KPKG(const KSharedConfigPtr &_config)
  : KMainWindow(0),
  config(KGlobal::config())
{
  kpackage = new KPACKAGE(_config, this);
  setCentralWidget(kpackage);

  config->setGroup("Kpackage");

  kpackage->management->readPSeparator();

  // Get a nice default size
  resize(760,540);

  setupMenu();
  disableNext();
  disablePrevious();

  optiondialog = new Options(this);

  prop_restart = false;
  setAutoSaveSettings();
}

// Set up the menu

void KPKG::setupMenu()
{

  pack_open = KStandardAction::open(kpackage, SLOT(fileOpen()),
			       actionCollection());

  recent = KStandardAction::openRecent(this, SLOT(openRecent(const KUrl&)),
				  actionCollection());
  recent->loadEntries( config.data() );

  pack_find = actionCollection()->addAction( "pack_find");
  pack_find->setText(i18n("Find &Package..."));
  pack_find->setIcon(KIcon("find"));
  qobject_cast<KAction*>( pack_find )->setShortcut(KStandardShortcut::shortcut(KStandardShortcut::Find));
  connect(pack_find, SIGNAL(triggered()), kpackage, SLOT(find()));

  pack_findf = actionCollection()->addAction( "pack_find");
  pack_findf->setText(i18n("Find &File..."));
  pack_findf->setIcon(KIcon("filefind"));
  connect(pack_findf, SIGNAL(triggered()), kpackage, SLOT(findf()));

  kpack_reload = actionCollection()->addAction( "kpack_reload" );
  kpack_reload->setText(i18n("&Reload"));
  kpack_reload->setIcon(KIcon("reload"));
  qobject_cast<KAction*>( kpack_reload )->setShortcut(KStandardShortcut::shortcut(KStandardShortcut::Reload));
  connect(kpack_reload, SIGNAL(triggered()), kpackage, SLOT(reload()));

  (void) KStandardAction::quit(kpackage, SLOT(fileQuit()),
			  actionCollection());

  pack_prev = KStandardAction::back(kpackage->management->treeList, SLOT(previous()),
			       actionCollection());
  actionCollection()->addAction( "pack_prev", pack_prev );

  pack_next = KStandardAction::forward(kpackage->management->treeList, SLOT(next()),
				  actionCollection());

  actionCollection()->addAction( "pack_next", pack_next );
  QAction *a = actionCollection()->addAction( "kpack_expand");

  a->setText(i18n("&Expand Tree"));
  a->setIcon(KIcon("ftout"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(expandTree()));

  a = actionCollection()->addAction("kpack_collapse");

  a->setText(i18n("&Collapse Tree"));
  a->setIcon(KIcon("ftin"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(collapseTree()));

  a = actionCollection()->addAction("kpack_clear");
  a->setText(i18n("Clear &Marked"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(clearMarked()));

  a = actionCollection()->addAction( "kpack_markall");
  a->setText(i18n("Mark &All"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(markAll()));

  pack_install = actionCollection()->addAction("install_single" );
  pack_install->setText(i18n("&Install"));
  connect(pack_install, SIGNAL(triggered()), kpackage->management, SLOT(installSingleClicked()));

  pack_install->setEnabled(false);
  kpackage->management->setInstallAction(pack_install);


  pack_uninstall = actionCollection()->addAction( "uninstall_single");
  pack_uninstall->setText(i18n("&Uninstall"));
  connect(pack_uninstall, SIGNAL(triggered()), kpackage->management, SLOT(uninstallSingleClicked()));

  pack_uninstall->setEnabled(false);
  kpackage->management->setUninstallAction(pack_uninstall);


  a = actionCollection()->addAction( "install_marked");
  a->setText(i18n("&Install Marked"));
  connect(a, SIGNAL(triggered()), kpackage->management, SLOT(installMultClicked()));

  a = actionCollection()->addAction( "unstall_marked");

  a->setText(i18n("&Uninstall Marked"));
  connect(a, SIGNAL(triggered()), kpackage->management, SLOT(uninstallMultClicked()));

  setStandardToolBarMenuEnabled(true);

  KStandardAction::configureToolbars( this, SLOT(configureToolBars()),
				 actionCollection());

  KStandardAction::saveOptions( this, SLOT(saveSettings()), actionCollection());

  KStandardAction::keyBindings( guiFactory(), SLOT(configureShortcuts()), actionCollection());

  a = actionCollection()->addAction( "kpack_options");

  a->setText(i18n("Configure &KPackage..."));
  a->setIcon(KIcon("configure"));
  connect(a, SIGNAL(triggered()), this, SLOT(setOptions()));

  a = actionCollection()->addAction( "clear_dcache");

  a->setText(i18n("Clear Package &Folder Cache"));
  connect(a, SIGNAL(triggered()), this, SLOT(clearDCache()));

  a = actionCollection()->addAction( "clear_pcache");
  a->setText(i18n("Clear &Package Cache"));
  connect(a, SIGNAL(triggered()), this, SLOT(clearPCache()));

  int i;
  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
      kpinterface[i]->makeMenu(actionCollection());
    }
  }

  //  urlList.setAutoDelete(TRUE);
  createGUI();
}

void KPKG::disableMenu()
{
  pack_open->setEnabled(false);
  pack_find->setEnabled(false);
  pack_findf->setEnabled(false);
  kpack_reload->setEnabled(false);
  recent->setEnabled(false);
}

void KPKG::enableMenu()
{
  pack_open->setEnabled(true);
  pack_find->setEnabled(true);
  pack_findf->setEnabled(true);
  kpack_reload->setEnabled(true);
  recent->setEnabled(true);
}

void KPKG::disableNext() {
  pack_next->setEnabled(false);
}

void KPKG::enableNext() {
  pack_next->setEnabled(true);
}

void KPKG::disablePrevious() {
  pack_prev->setEnabled(false);
}

void KPKG::enablePrevious() {
  pack_prev->setEnabled(true);
}
void KPKG::openRecent(const KUrl& url){
  kpackage->openNetFile( url );
}

void KPKG::add_recent_file(const QString &newfile){

  KUrl url = KUrl(newfile);

  recent->addUrl( url );
}

void KPKG::configureToolBars() {
  KEditToolbar dlg(actionCollection());
  connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
  dlg.exec();
}

void KPKG::slotNewToolbarConfig() {
  createGUI();
}

void KPKG::writeSettings(){

  kpackage->management->writePSeparator();

  KSharedConfig::Ptr config = KGlobal::config();

  config->setGroup("Kpackage");

  recent->saveEntries( config.data() );

  kpackage->management->treeList->writeTreePos();
  kpackage->management->treeList->writeTreeType();

  config->sync();
}

void KPKG::setOptions(){
  optiondialog->restore();
}

void KPKG::saveSettings(){
  writeSettings();
}

void KPKG::clearPCache(){
  cacheObj::clearPCache();
}

void KPKG::clearDCache(){
  cacheObj::clearDCache();
}

void KPKG::saveProperties(KSharedConfigPtr config )
{
    config->writePathEntry("Name", kpackage->save_url.url());
}


void KPKG::readProperties(const KSharedConfigPtr &config)
{
    QString entry = config->readPathEntry("Name"); // no default
    if (entry.isNull())
	return;
	QStringList lst;
	lst <<entry;
    kpackage->openNetFiles(lst);
    prop_restart = true;
}

void KPKG::closeEvent ( QCloseEvent *) {
    kpackage->fileQuit();
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

KPACKAGE::KPACKAGE(const KSharedConfigPtr &_config, QWidget *parent)
  : QWidget(parent)
{

  // Save copy of config
  config = _config;

  setAcceptDrops(true);
  setupModeWidgets();

  setupStatusBar();

  file_dialog = NULL;
  findialog = NULL;
  srchdialog = NULL;

}

// Destructor
KPACKAGE::~KPACKAGE()
{
  //  destroyModeWidgets();
  //  delete status;
}

// resize event -- arrange the widgets
void KPACKAGE::resizeEvent(QResizeEvent *re)
{
  re = re;			// prevent warning
  arrangeWidgets();
}

// Set up the mode widgets
void KPACKAGE::setupModeWidgets()
{
  management = new managementWidget(this);

  for (int i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
      kpinterface[i]->uninstallation = new pkgOptionsU(kpinterface[i]);
      kpinterface[i]->installation = new pkgOptionsI(kpinterface[i]);
    }
  }
}

// destroy the mode widgets
void KPACKAGE::destroyModeWidgets()
{
  //  delete management;
  //  for (int i = 0; i < kpinterfaceN; i++) {
  //    if (kpinterface[i]) {
  //      delete kpinterface[i]->installation;
  //      delete kpinterface[i]->uninstallation;
  //    }
  //  }
}


// Set up the status bar
void KPACKAGE::setupStatusBar()
{
  statusbar = new QFrame(this);
  statusbar->setFrameStyle(QFrame::Raised | QFrame::Panel);
  processProgress = new QProgressBar(statusbar);
  processProgress->setRange(0, 100);
  processProgress->setValue(0);
  processProgress->setTextVisible(FALSE);

  status = new QLabel(i18n("Management Mode"), statusbar);
}

// Arrange the widgets nicely
void KPACKAGE::arrangeWidgets()
{
  int i;

  statusbar->resize(width(),20);
  statusbar->move(0,height()-20);
  status->resize((statusbar->width() / 4) * 3, 16);
  status->move(2,2);
  processProgress->resize(statusbar->width() / 4 - 4, 16);
  processProgress->move((statusbar->width() / 4) * 3 + 3, 2);

  management->resize(width(),height() - 20);

  for (i = 0; i < kpinterfaceN; i++)
    if (kpinterface[i]) {
      kpinterface[i]->installation->resize(width(),height() - 20);
    }
}

void KPACKAGE::setup()
{
  management->collectData(1);
}

void KPACKAGE::fileQuit()		// file->quit selected from menu
{
  kpkg->writeSettings();
  if (opts->DCache >= Opts::SESSION) {
    cacheObj::clearDCache(); // clear dir caches if needed
  }
  if (opts->PCache >= Opts::SESSION) {
    cacheObj::clearPCache(); // clear package caches if needed
  }

  KApplication::exit(0);	// exit the application
}

void KPACKAGE::reload()
{
  kpackage->management->collectData(TRUE);
}

void KPACKAGE::fileOpen()		// file->quit selected from menu
{
    KFileDialog *box;

    box = getFileDialog(i18n("Select Package"));

    if( box->exec())
    {
        if(!box->selectedUrl().isEmpty())
        {
            openNetFile( box->selectedUrl() );
        }
    }
}

void KPACKAGE::clearMarked()
{
  management->treeList->clearMarked(management->treeList->firstChild());
}

void KPACKAGE::markAll()
{
  management->treeList->markAll(management->treeList->firstChild());
}

void KPACKAGE::expandTree()
{
  management->treeList->expandTree(management->treeList);
}

void KPACKAGE::collapseTree()
{
  management->treeList->collapseTree(management->treeList);
}

pkgInterface *KPACKAGE::pkType(const QString &fname)
{
  // Get the package information for this package
  char buf[51];
  int i;

  FILE *file= fopen(QFile::encodeName(fname),"r");
  if (file) {
    fgets(buf,sizeof(buf)-1,file);
    buf[50] = 0;

    // check enabled package handlers
    for (i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i]) {
	if (opts->handlePackage[i] && kpinterface[i]->isType(buf, fname)) {
	  fclose(file);
	  return kpinterface[i];
	}
      }
    }
    // check unenabled package handlers
    for (i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i]) {
	if (!opts->handlePackage[i] && kpinterface[i]->isType(buf, fname)) {
	  fclose(file);
	  return kpinterface[i];
	}
      }
    }
    fclose(file);
    KpMsgE(i18n("Unknown package type: %1", fname),TRUE);
  } else {
    KpMsgE(i18n("File not found: %1", fname),TRUE);
  }

  return 0;
}

/////////////////////////////////////////////////////////////////////////
int KPACKAGE::typeIndex(pkgInterface *type) {
  int i;
  for (i = 0; i < kpinterfaceN; i++) {
    if (type ==  kpinterface[i]) {
      return i;
    }
  }
  return -1;
}

void KPACKAGE::openNetFiles (const QStringList &urls, bool install )
{
  QStringList files;
  int i;
  int index;
  Q3PtrList<packageInfo> **lst = new Q3PtrList<packageInfo>*[kpinterfaceN];
  packageInfo *pk = 0;

  kDebug() << "openNetFiles\n";

  for (QStringList::ConstIterator it = urls.begin(); it != urls.end(); ++it) {
    files.append(fetchNetFile(*it));
    kpkg->add_recent_file(*it);
  }

  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
      lst[i] = new Q3PtrList<packageInfo>;
    }
  }

  for (QStringList::Iterator t = files.begin(); t != files.end(); ++t) {
    pkgInterface *type = pkType(*t);
    index = typeIndex(type);
    if (index >= 0) {
      pk = type->getPackageInfo('u', *t, 0);
      if (pk) {
	pk->pkgFileIns(*t);
	lst[index]->insert(0,pk);
        }
      }
    }

  if (install)
    for (i = 0; i < kpinterfaceN; i++) {
      if (kpinterface[i]) {
	if ( lst[i]->count() > 0) {
	  kpinterface[i]->installation->setup(lst[i],kpinterface[i]->head);
	  if (kpinterface[i]->installation->exec()) {
	    for (packageInfo *inf = lst[i]->first(); inf != 0; inf = lst[i]->next()) {
	      kpackage->management->updatePackage(inf,TRUE);
	    }
	  }
	}
      }
    } else {
      if (pk) {
	KpTreeListItem *pt = pk->item;
	// NOT the best place for this CODE
	kpackage->management->tabChanged(Opts::ALL);
	if (pt)
	  kpackage->management->packageHighlighted(pt);
      }
    }

  // Dealloc memory
  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i]) {
	delete lst[i];
    }
  }
  delete [] lst;
}

void KPACKAGE::openNetFile(const KUrl &url, bool install )
{
  QStringList lst;
  lst<<url.url();
  openNetFiles(lst, install);
}

//    KMimeMagic *magic = KMimeMagic::self();
//    KMimeMagicResult *r = magic->findFileType(s);
    //    printf("r=%s\n",(r->mimeType()).data());



QString KPACKAGE::getFileName(const KUrl & url, QString &cacheName )
{
  QString none  = "";
  QString fname = "";

  if ( !url.isValid() )  {
    KpMsgE(i18n("Malformed URL: %1", url.url()),TRUE);
  } else {

    // Just a usual file ?
    if ( url.isLocalFile() ) {
      cacheName = url.path();
      fname = url.path();
    } else {

      QString tmpd = cacheObj::PDir();
      if (!tmpd.isEmpty()) {

	QString cacheFile = tmpd + url.fileName();

	cacheName = cacheFile;
	QFileInfo f(cacheFile);
	if (f.exists() && (opts->DCache != Opts::NEVER)) {
	  fname =  cacheFile;
	}
      }
    }
  }
  return fname;
}

bool KPACKAGE::isFileLocal( const KUrl & url )
{
  QString cf;

  QString f = getFileName(url, cf);

  if (cf.isEmpty()) {
    return false;
  } else {
    if (!f.isEmpty()) {
      return true;
    } else {
      return false;
    }
  }
}

QString KPACKAGE::fetchNetFile( const KUrl & url )
{

  QString cf;

  QString f = getFileName(url, cf);

  if (cf.isEmpty()) {
    return "";
  } else {

    if (!f.isEmpty()) {
      return f;
    } else {
      save_url = url;

      setStatus(i18n("Starting KIO"));

      Kio kio;

      if (kio.download(url, cf)) {
	setStatus(i18n("KIO finished"));
	QFileInfo fi(cf);
	if (!(fi.exists() && fi.size() > 0)) {
          unlink(QFile::encodeName(cf));
	  return "";
	} else {
          CacheList cl(fi.path());
          cl.append(fi.fileName());
          cl.write();
	  return cf;
	}
      } else {
	setStatus(i18n("KIO failed"));
	return "";
      }
    }
  }
}

/////////////////////////////////////////////////////////////////////////
void KPACKAGE::fileOpenUrl(){

  bool ok;

  QString url = KInputDialog::getText( QString::null,
      i18n( "Open location:" ), save_url.prettyUrl(), &ok, this );

  if ( ok )
    {
      kpkg->add_recent_file( url );
      openNetFile( url );
    }
}

void KPACKAGE::find(){
  if (srchdialog)
    srchdialog->show();
  else
    srchdialog = new Search(this, "find package");
}

void KPACKAGE::findf(){
  if (findialog)
    findialog->show();
  else
    findialog = new FindF(this);
}

KFileDialog* KPACKAGE::getFileDialog(const QString &captiontext)
{

  if(!file_dialog) {
    file_dialog = new KFileDialog(QDir::currentDirPath(), "",
				  this);
  }

  QString pat;
  for (int i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i] && opts->handlePackage[i]) {
      pat += kpinterface[i]->packagePattern;
      pat += " ";
    }
  }
  file_dialog->setFilter(pat);
  file_dialog->setCaption(captiontext);
  //  file_dialog->rereadDir();

  return file_dialog;
}

void KPACKAGE::dragEnterEvent(QDragEnterEvent* e)
{
  e->accept(KUrl::List::canDecode(e->mimeData()));
}

void KPACKAGE::dropEvent(QDropEvent *de) // something has been dropped
{

  KUrl::List list = KUrl::List::fromMimeData( de->mimeData() );
 if ( list.isEmpty() )
     return;

  openNetFiles(list.toStringList());
}

void KPACKAGE::setStatus(const QString &s)	// set the text in the status bar
{
  status->setText(s);
  kapp->processEvents();	// refresh the screen
}

QString KPACKAGE::getStatus()	// get the text in the status bar
{
  if(status)
    return status->text();
  else
    return "";
}

void KPACKAGE::setPercent(int x)	// set the progress in the status bar
{
  processProgress->setValue(x);
  kapp->processEvents();	// refresh it
}

//////////////////////////////////////////////////////////////////////////////



#include "kpackage.moc"
