/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
// Author: Damyan Pepper
//         Toivo Pedaste
//
// See kpackage.h for more information.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include <kactioncollection.h>
#include <kapplication.h>
#include <QtCore/QDir>
#include <QtGui/QLabel>
#include <QtGui/QFrame>
//Added by qt3to4:
#include <QtGui/QDragEnterEvent>
#include <QtGui/QResizeEvent>
#include <QtGui/QDropEvent>
#include <QtGui/QCloseEvent>
#include <Qt3Support/Q3PtrList>

#include <kdebug.h>
#include <kxmlguifactory.h>
#include <kfiledialog.h>
#include <QtGui/QProgressBar>
#include <kurl.h>
#include <krecentfilesaction.h>
#include <kaction.h>
#include <klocale.h>
#include <kinputdialog.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kstandardaction.h>
#include <kedittoolbar.h>
#include <kstandardshortcut.h>
#include <kio/netaccess.h>
#include <kmessagebox.h>

#include "kpackage.h"
#include "managementWidget.h"
#include "pkgOptions.h"
#include "findf.h"
#include "search.h"
#include "options.h"

extern Opts *opts;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
KPKG::KPKG(const KSharedConfigPtr &_config)
  : KXmlGuiWindow(0),
  config(KGlobal::config())
{
  kpackage = new KPACKAGE(_config, this);
  setCentralWidget(kpackage);

  kpackage->management->readPSeparator();

  // Get a nice default size
  resize(760,540);

  setupMenu();
  disableNext();
  disablePrevious();

  optiondialog = new Options(this);

  prop_restart = false;
  setAutoSaveSettings();
}

// Set up the menu

void KPKG::setupMenu()
{

  pack_open = KStandardAction::open(kpackage, SLOT(fileOpen()),
			       actionCollection());

  recent = KStandardAction::openRecent(this, SLOT(openRecent(const KUrl&)),
				  actionCollection());
  KConfigGroup group(config, "Kpackage");
  recent->loadEntries( group );

  pack_find = actionCollection()->addAction( "pack_find");
  pack_find->setText(i18n("Find &Package..."));
  pack_find->setIcon(KIcon("edit-find"));
  qobject_cast<KAction*>( pack_find )->setShortcut(KStandardShortcut::shortcut(KStandardShortcut::Find));
  connect(pack_find, SIGNAL(triggered()), kpackage, SLOT(find()));

  pack_findf = actionCollection()->addAction( "pack_findf");
  pack_findf->setText(i18n("Find &File..."));
  pack_findf->setIcon(KIcon("file-find"));
  connect(pack_findf, SIGNAL(triggered()), kpackage, SLOT(findf()));

  kpack_reload = actionCollection()->addAction( "kpack_reload" );
  kpack_reload->setText(i18n("&Reload"));
  kpack_reload->setIcon(KIcon("view-refresh"));
  qobject_cast<KAction*>( kpack_reload )->setShortcut(KStandardShortcut::shortcut(KStandardShortcut::Reload));
  connect(kpack_reload, SIGNAL(triggered()), kpackage, SLOT(reload()));

  (void) KStandardAction::quit(kpackage, SLOT(fileQuit()),
			  actionCollection());

  pack_prev = KStandardAction::back(kpackage->management->treeList, SLOT(previous()),
			       actionCollection());
  actionCollection()->addAction( "pack_prev", pack_prev );

  pack_next = KStandardAction::forward(kpackage->management->treeList, SLOT(next()),
				  actionCollection());

  actionCollection()->addAction( "pack_next", pack_next );
  QAction *a = actionCollection()->addAction( "kpack_expand");

  a->setText(i18n("&Expand Tree"));
  a->setIcon(KIcon("ftout"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(expandTree()));

  a = actionCollection()->addAction("kpack_collapse");

  a->setText(i18n("&Collapse Tree"));
  a->setIcon(KIcon("ftin"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(collapseTree()));

  a = actionCollection()->addAction("kpack_clear");
  a->setText(i18n("Clear &Marked"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(clearMarked()));

  a = actionCollection()->addAction( "kpack_markall");
  a->setText(i18n("Mark &All"));
  connect(a, SIGNAL(triggered()), kpackage, SLOT(markAll()));

  pack_install = actionCollection()->addAction("install_single" );
  pack_install->setText(i18n("&Install"));
  connect(pack_install, SIGNAL(triggered()), kpackage->management, SLOT(installSingleClicked()));

  pack_install->setEnabled(false);
  kpackage->management->setInstallAction(pack_install);


  pack_uninstall = actionCollection()->addAction( "uninstall_single");
  pack_uninstall->setText(i18n("&Uninstall"));
  connect(pack_uninstall, SIGNAL(triggered()), kpackage->management, SLOT(uninstallSingleClicked()));

  pack_uninstall->setEnabled(false);
  kpackage->management->setUninstallAction(pack_uninstall);


  a = actionCollection()->addAction( "install_marked");
  a->setText(i18n("&Install Marked"));
  connect(a, SIGNAL(triggered()), kpackage->management, SLOT(installMultClicked()));

  a = actionCollection()->addAction( "unstall_marked");

  a->setText(i18n("&Uninstall Marked"));
  connect(a, SIGNAL(triggered()), kpackage->management, SLOT(uninstallMultClicked()));

  setStandardToolBarMenuEnabled(true);

  KStandardAction::configureToolbars( this, SLOT(configureToolBars()),
				 actionCollection());

  KStandardAction::saveOptions( this, SLOT(saveSettings()), actionCollection());

  KStandardAction::keyBindings( guiFactory(), SLOT(configureShortcuts()), actionCollection());

  a = actionCollection()->addAction( "kpack_options");

  a->setText(i18n("Configure &KPackage..."));
  a->setIcon(KIcon("configure"));
  connect(a, SIGNAL(triggered()), this, SLOT(setOptions()));


  kpinterface[DEBt]->makeMenu(actionCollection());
 
  //  urlList.setAutoDelete(TRUE);
  createGUI();
}

void KPKG::disableMenu()
{
  pack_open->setEnabled(false);
  pack_find->setEnabled(false);
  pack_findf->setEnabled(false);
  kpack_reload->setEnabled(false);
  recent->setEnabled(false);
}

void KPKG::enableMenu()
{
  pack_open->setEnabled(true);
  pack_find->setEnabled(true);
  pack_findf->setEnabled(true);
  kpack_reload->setEnabled(true);
  recent->setEnabled(true);
}

void KPKG::disableNext() {
  pack_next->setEnabled(false);
}

void KPKG::enableNext() {
  pack_next->setEnabled(true);
}

void KPKG::disablePrevious() {
  pack_prev->setEnabled(false);
}

void KPKG::enablePrevious() {
  pack_prev->setEnabled(true);
}
void KPKG::openRecent(const KUrl& url){
  kpackage->openNetFile( url );
}

void KPKG::add_recent_file(const QString &newfile){

  KUrl url = KUrl(newfile);

  recent->addUrl( url );
}

void KPKG::configureToolBars() {
  KEditToolBar dlg(actionCollection());
  connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
  dlg.exec();
}

void KPKG::slotNewToolbarConfig() {
  createGUI();
}

void KPKG::writeSettings(){

  kpackage->management->writePSeparator();

  KConfigGroup group(config, "Kpackage");
  recent->saveEntries( group );

  kpackage->management->treeList->writeTreePos();

  config->sync();
}

void KPKG::setOptions(){
  optiondialog->restore();
}

void KPKG::saveSettings(){
  writeSettings();
}

void KPKG::saveProperties(KConfigGroup& config )
{
    config.writePathEntry("Name", kpackage->save_url.url());
}


void KPKG::readProperties(const KConfigGroup &config)
{
    QString entry = config.readPathEntry("Name"); // no default
    if (entry.isNull())
	return;
    QStringList lst;
    lst <<entry;
    kpackage->openNetFiles(lst);
    
    prop_restart = true;
}

void KPKG::closeEvent ( QCloseEvent *) {
    kpackage->fileQuit();
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

KPACKAGE::KPACKAGE(const KSharedConfigPtr &_config, QWidget *parent)
  : QWidget(parent)
{

  // Save copy of config
  config = _config;

  setAcceptDrops(true);
  setupModeWidgets();

  setupStatusBar();

  file_dialog = NULL;
  findialog = NULL;
  srchdialog = NULL;

}

// Destructor
KPACKAGE::~KPACKAGE()
{
}

// resize event -- arrange the widgets
void KPACKAGE::resizeEvent(QResizeEvent *re)
{
  re = re;			// prevent warning
  arrangeWidgets();
}

// Set up the mode widgets
void KPACKAGE::setupModeWidgets()
{
  management = new managementWidget(this);

      kpinterface[0]->uninstallation = new pkgOptionsU(kpinterface[0]);
      kpinterface[0]->installation = new pkgOptionsI(kpinterface[0]);
}

// Set up the status bar
void KPACKAGE::setupStatusBar()
{
  statusbar = new QFrame(this);
  statusbar->setFrameStyle(QFrame::Raised | QFrame::Panel);
  processProgress = new QProgressBar(statusbar);
  processProgress->setRange(0, 100);
  processProgress->setValue(0);
  processProgress->setTextVisible(false);

  status = new QLabel(i18n("Management Mode"), statusbar);
}

// Arrange the widgets nicely
void KPACKAGE::arrangeWidgets()
{
  statusbar->resize(width(),20);
  statusbar->move(0,height()-20);
  status->resize((statusbar->width() / 4) * 3, 16);
  status->move(2,2);
  processProgress->resize(statusbar->width() / 4 - 4, 16);
  processProgress->move((statusbar->width() / 4) * 3 + 3, 2);

  management->resize(width(),height() - 20);

  kpinterface[0]->installation->resize(width(),height() - 20);
}

void KPACKAGE::setup()
{
  management->collectData(1);
}

void KPACKAGE::fileQuit()		// file->quit selected from menu
{
  kpkg->writeSettings();
 
  KApplication::exit(0);	// exit the application
}

void KPACKAGE::reload()
{
  kpackage->management->collectData(true);
}

void KPACKAGE::fileOpen()		
{
    KFileDialog *box;

    box = getFileDialog(i18n("Select Package"));

    if( box->exec()) {
        if(!box->selectedUrl().isEmpty()) {
            openNetFile( box->selectedUrl() );
        }
    }
}

void KPACKAGE::clearMarked()
{
  management->treeList->clearMarked(management->treeList->firstChild());
}

void KPACKAGE::markAll()
{
  management->treeList->markAll(management->treeList->firstChild());
}

void KPACKAGE::expandTree()
{
  management->treeList->expandTree(management->treeList);
}

void KPACKAGE::collapseTree()
{
  management->treeList->collapseTree(management->treeList);
}


/////////////////////////////////////////////////////////////////////////

void KPACKAGE::openNetFiles (const QStringList &urls, bool install )
{
  QStringList files, names;
  
  QList<packageInfo *> lst;
  packageInfo *pk = 0;

  kDebug() << "openNetFiles\n";

  foreach (QString it, urls) {
    QString f = fetchNetFile(it);
    if (!f.isEmpty())
      files.append(f);
    kpkg->add_recent_file(it);
  }

  if (files.count() > 0) {
   foreach (QString t, files) {
     kDebug() << "T=" << t << "\n";
      pk = kpinterface[0]->collectPath(t);
      if (pk) {
       kDebug() << "PK OK\n";
       pk->pkgFileIns(t);
       lst.append(pk);
       names.append(pk->getInfo("name"));
      }
    }
  
    if (install) {
      kpinterface[0]->installation->setup(lst);
      if (kpinterface[0]->installation->exec()) {
        kpackage->management->updatePackageState(lst, true);
      }
    } else {
     if (pk) {
        KpTreeListItem *pt = pk->item;
	// NOT the best place for this CODE
       kpackage->management->filterChanged(Opts::ALL);
        if (pt)
  	kpackage->management->packageHighlighted(pt);
      }
    }
  }
}

void KPACKAGE::openNetFile(const KUrl &url, bool install )
{
  QStringList lst;
  lst<<url.url();
  openNetFiles(lst, install);
}

//    KMimeMagic *magic = KMimeMagic::self();
//    KMimeMagicResult *r = magic->findFileType(s);
    //    printf("r=%s\n",(r->mimeType()).data());



QString KPACKAGE::getFileName(const KUrl & url, QString &cacheName )
{
  QString none  = "";
  QString fname = "";

  if ( !url.isValid() )  {
    KpMsgE(i18n("Malformed URL: %1", url.url()), true);
  } else {

    // Just a usual file ?
    if ( url.isLocalFile() ) {
      cacheName = url.path();
      fname = url.path();
    } else {
    }
  }
  return fname;
}

bool KPACKAGE::isFileLocal( const KUrl & url )
{
  QString cf;

  QString f = getFileName(url, cf);

  if (cf.isEmpty()) {
    return false;
  } else {
    if (!f.isEmpty()) {
      return true;
    } else {
      return false;
    }
  }
}

QString KPACKAGE::fetchNetFile( const KUrl & url )
{
  QString tmpFile = KStandardDirs::locateLocal("tmp",url.fileName());
  if ( !KIO::NetAccess::download( url, tmpFile, this) ) {
      KMessageBox::error(this, KIO::NetAccess::lastErrorString() );
       return "";
  }
  return tmpFile;
}

/////////////////////////////////////////////////////////////////////////
void KPACKAGE::fileOpenUrl(){

  bool ok;

  QString url = KInputDialog::getText( QString::null,	//krazy:exclude=nullstrassign for old broken gcc
      i18n( "Open location:" ), save_url.prettyUrl(), &ok, this );

  if ( ok )
    {
      kpkg->add_recent_file( url );
      openNetFile( url );
    }
}

void KPACKAGE::find(){
  if (srchdialog)
    srchdialog->show();
  else
    srchdialog = new Search(this, "find package");
}

void KPACKAGE::findf(){
  if (findialog)
    findialog->show();
  else
    findialog = new FindF(this);
}

KFileDialog* KPACKAGE::getFileDialog(const QString &captiontext)
{

  if(!file_dialog) {
    file_dialog = new KFileDialog(QDir::currentPath(), "",
				  this);
  }

  QString pat = "*.deb *.rpm *.tgz";
  
  file_dialog->setFilter(pat);
  file_dialog->setCaption(captiontext);
  //  file_dialog->rereadDir();

  return file_dialog;
}

void KPACKAGE::dragEnterEvent(QDragEnterEvent* e)
{
  e->setAccepted(KUrl::List::canDecode(e->mimeData()));
}

void KPACKAGE::dropEvent(QDropEvent *de) // something has been dropped
{

  KUrl::List list = KUrl::List::fromMimeData( de->mimeData() );
 if ( list.isEmpty() )
     return;

  openNetFiles(list.toStringList());
}

void KPACKAGE::setStatus(const QString &s)	// set the text in the status bar
{
  status->setText(s);
 qApp->processEvents();	// refresh the screen
}

QString KPACKAGE::getStatus()	// get the text in the status bar
{
  if(status)
    return status->text();
  else
    return "";
}

void KPACKAGE::setPercent(int x)	// set the progress in the status bar
{
 processProgress->setValue(x);
 qApp->processEvents();	// refresh it
}

//////////////////////////////////////////////////////////////////////////////



#include "kpackage.moc"
