/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#ifndef OPTIONS_H
#define OPTIONS_H

// Standard Headers
#include <stdio.h>

// Qt Headers
#include <QtCore/QDir>
#include <QtGui/QWidget>
#include <Qt3Support/Q3FileDialog>
#include <Qt3Support/Q3GroupBox>
//Added by qt3to4:
#include <QtGui/QVBoxLayout>

// KDE headers
#include <kfiledialog.h>
#include <kdialog.h>
#include <kpackage.h>
#include <kpagedialog.h>

class KUrlRequester;

class QVBoxLayout;
class Q3GroupBox;
class QCheckBox;
class QPushButton;
class KComboBox;
class Q3ButtonGroup;
class QRadioButton;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class Options : public KPageDialog
{
  Q_OBJECT

public:

  Options ( QWidget *parent = 0);
  ~Options();

  void restore();
  // show window, setting the buttons

  void setValues();
  // set the dialog to match options values

private:

  bool verifyFL;
  bool PkgRead;
  bool fRemote;
  int  DCache, dc, PCache, pc, privCmd, prc;
  QString CacheDir;

  QVBoxLayout* vl;

  QVBoxLayout* vt;
  Q3GroupBox *framet;
  Q3GroupBox *packageBox;
  QCheckBox *packageHandle;
  QPushButton *locate;

  Q3GroupBox *hh;
  QCheckBox *huse;
  KComboBox *hosts;

  QVBoxLayout* vb;
  Q3ButtonGroup *bg;
  QRadioButton *disp[4];

  QVBoxLayout*  vc;
  Q3ButtonGroup *bc;
  QRadioButton *dcache[3];

  QVBoxLayout*  vp;
  Q3ButtonGroup *bp;
  QRadioButton *pcache[3];

  QVBoxLayout*  vs;
  Q3ButtonGroup *bs;
  QRadioButton *privs[3];
  
  KUrlRequester *cachedir;

  QVBoxLayout* vr;
  Q3GroupBox *framer;
  QCheckBox *pkgRead;

  QVBoxLayout* vf;
  Q3GroupBox *framem;
  QCheckBox *valid;


public slots:
    void scanLocates();
    void apply_slot();
    void cancel_slot();
    void PDCache(int);
    void PPCache(int);
    void PPrivs(int);
  
private slots:
    void insHosts();
    void useRemote();
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

class Opts
{
public:
  void readSettings(const QString &initHost = "");
  void writeSettings();

  void readLaterSettings();
  // options to be setup after package interfaces setup

  QStringList hostList;
  // list of hosts to choose from

  bool VerifyFL;
  // config: verify the file list

  bool PkgRead;
  // read information about uninstalled packages from each RPM file itself


  enum {INSTALLED, NEW, UPDATES, AVAILABLE, ALL};
  enum {ALWAYS, SESSION, NEVER};

  int DCache;
  // how much to cache uninstall package directories

  int PCache;
  // how much to cache uninstall packages
  
  int privCmd;
  // which command to use to execute priveliged commands
  enum {SUcmd=0, SUDOcmd=1, SSHcmd=2};

  QString CacheDir;
  // cache directory

  Opts(const QString &initHost);
  ~Opts();
};
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif
