/***************************************************************************
                       splashscreen.h  -  description
                            -------------------
   begin                : Fri Nov 30 2001
  copyright            : (C) 2001 by Matthias Messmer <bmlmessmer@web.de> &
                                     Carsten Niehaus <cniehaus@gmx.de> &
                                     Robert Gogolok <mail@robert-gogolok.de>

***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QLabel>
#include <QTimer>
#include <QPixmap>

// KDE includes
#include <kstandarddirs.h>

// local includes
#include "kpercentage.h"
#include "ksplashscreen.h"

/* creates the splash window without titlebar and border */
KSplashScreen::KSplashScreen( KPercentage *percentage ) :
        KDialog( 0L, Qt::FramelessWindowHint )
{
    percentage_window = percentage;
    resize( 380, 300 );
    /* load the background pixmap */
    QPixmap bgp( KStandardDirs::locate( "data", "kpercentage/pics/splash.png" ) );
	
    /* wait some time and start the main window */
	QLabel * label = new QLabel( this );
	label->setFixedSize( 380, 300 );
	label->setPixmap( bgp );
    QTimer::singleShot( 2000, this, SLOT( showPercentage() ) );
}

/* show the main window and close the splah window */
void KSplashScreen::showPercentage()
{
    percentage_window->show();
    delete( this );
}

#include "ksplashscreen.moc"
