/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999-2001 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  $Id: kbgengine.cpp 611572 2006-12-08 20:53:37Z sawkey $

*/

#include <QTimer>
//#include <q3popupmenu.h>
#include <QMenu>
#include <kdialog.h>

#include <kbgengine.moc>
#include "kbgengine.h"
#include <kmainwindow.h>

/*
 * Constructor initializes the QObject
 */
KBgEngine::KBgEngine(KMainWindow *parent, QMenu *pmenu)
    : QObject(parent)
{
    menu = pmenu;
    cl = -1;
    ct = new QTimer(this);
    connect(ct, SIGNAL(timeout()), this, SLOT(done()));
}

/*
 * Destructor is empty
 */
KBgEngine::~KBgEngine()
{
    // empty
}

/*
 * Set the length of the commit timeout. Negative values disable the
 * feature.
 */
void KBgEngine::setCommit(const double com)
{
    cl = int(1000*com);
}

// EOF
