/**
 * Copyright Michel Filippi <mfilippi@sade.rhein-main.de>
 *           Robert Williams
 *           Andrew Chant <andrew.chant@utoronto.ca>
 *           André Luiz dos Santos <andre@netvision.com.br>
 * Copyright (C) 2004-2005 Benjamin C. Meyer <ben at meyerhome dot net>
 *
 * This file is part of the ksnake package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <QTimer>
#include <QList>

#include "board.h"
#include "basket.h"
#include "pixServer.h"

Kaffee::Kaffee(int pos, int r1, int r2)
{
    p = pos;
    t = Red;
    r = r2;
    QTimer::singleShot( r1, this, SLOT(golden()) );
    dirty = true;
}

void Kaffee::golden()
{
    dirty = true;
    t = (t == Red ? Golden : Red);
    QTimer::singleShot( r, this, SLOT(golden()) );
}

Basket::Basket(Board *b, PixServer *p)
{
    board = b;
    pixServer = p;
    list = new QList<Kaffee*>;
}

Basket::~Basket()
{
	qDeleteAll(*list);
	delete list;
}

void Basket::clear()
{
    if( !list->isEmpty())
	list->clear();
}

void Basket::newApples()
{
    int x;
    int i = 0;

    while(i < 10) {
	x =  random.getLong(board->count());
	if (x < board->count() && board->isEmpty(x) && x > BoardWidth+4) {
	    Kaffee *g = new Kaffee(x, random.getLong(40000), random.getLong(40000));
	    board->set(x, Apple);
	    list->append(g);
	    i++;
	}
    }
}

void Basket::repaint(bool dirty )
{
    foreach( Kaffee *g, *list ) {
	if (dirty) {
	    pixServer->draw(g->position(), ApplePix, (int)g->type());
	    g->dirty = false;
	}
	else if (g->dirty) {
	    pixServer->draw(g->position(), ApplePix, (int)g->type());
	    g->dirty = false;
	}
    }
}

Fruits Basket::eaten(int i)
{
    Fruits f = Red;

    foreach( Kaffee *g, *list )
	{
	    if (g->position() == i) {
		f = g->type();
                // safe to call remove while iterating,
                // because we break immediately after.
		list->removeAll(g);
		break;
	    }
	}
    if (list->isEmpty())
	emit openGate();

    return f;
}

#include "basket.moc"
