#ifndef KEYS_H
#define KEYS_H

#include <QMap>
//Added by qt3to4:
#include <QKeyEvent>
#include <QVector>
#include <Q3Signal>
#include <kaction.h>
#include <kactioncollection.h>

#include "mp_interface.h"


class KeyData : public QObject
{
 Q_OBJECT
 public:
    KeyData(uint maxNb, uint nbActions, const ActionData *,
            QObject *parent);
    void setKeycodes(uint nb, uint i, const int *keycodes);

    void setCurrentNb(uint nb);
    void clear();
    void createActionCollection(int index, QWidget *receiver);
    void setEnabled(uint index, bool enabled);
    void addKeys(KKeyDialog &);
    void save();

    void keyEvent(QKeyEvent *e, bool pressed);

 private:
    uint                                   _maxNb;
    QVector<ActionData>                  _data;
    QMap<int, QMap<int, QVector<int> > > _keycodes;
    QVector<KActionCollection *>         _cols;
    struct SpecialData {
        bool enabled;
        Q3Signal *pressed, *released;
    };
    QMap<QAction *, SpecialData>           _specActions;

    QString group() const
        { return QString("Keys (%1 humans)").arg(_cols.size()); }
};

#endif // KEYS_H
