#include "socket.h"

#include <config-libksirtet.h>
#include <sys/types.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#include <ctype.h>
#include <netdb.h>
#include <sys/utsname.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <unistd.h>
#include <sys/ioctl.h>
#ifdef HAVE_SYS_FILIO_H
#include <sys/filio.h> // for FIONREAD
#endif

#include <kserversocket.h>

Socket::Socket(KNetwork::KSocketBase *s, bool createNotifier,
               QObject *parent)
: _socket(s), _notifier(0)
{
    Q_ASSERT(s);
	if (createNotifier) {
		_notifier = new QSocketNotifier(s->socketDevice()->socket(), QSocketNotifier::Read,
                                        parent);
		_notifier->setEnabled(false);
	}
}

Socket::~Socket()
{
	delete _notifier;
    delete _socket;
}

bool Socket::write(const QByteArray &a)
{
	return ( _socket->socketDevice()->writeData(a.data(), a.size())==(int)a.size() );
}

bool Socket::write()
{
	bool res = write(writing.buffer());
	writing.clear();
	return res;
}

int Socket::pendingData() const
{
	int size = 0;
#ifdef __GNUC__
#warning TODO: use knetwork
#endif
	if ( ioctl(_socket->socketDevice()->socket(), FIONREAD, (char *)&size)<0 ) return -1;
	return size;
}

int Socket::read()
{
	reading.clearRead();

	int size = pendingData();
	if ( size==-1 ) return -1;

	reading.device()->close();
	int dec = reading.size();
	reading.buffer().resize(dec + size);
	size = _socket->socketDevice()->readData(reading.buffer().data() + dec, size);
	if ( size==-1 ) reading.buffer().resize(dec);
	reading.device()->open(QIODevice::ReadOnly);

	return size;
}

KNetwork::KSocketBase *Socket::accept()
{
	KNetwork::KServerSocket *server = dynamic_cast<KNetwork::KServerSocket *>(_socket);
	Q_ASSERT(server);
	return server->accept();
}
