/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999-2001 Jens Hoefkens <jens@hoefkens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include <kapplication.h>

#include <klocale.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kglobal.h>

#include "kbg.h"
#include "version.h"

static const char description[] = I18N_NOOP("A Backgammon program for KDE");
static const char notice[]      = I18N_NOOP("This is a graphical backgammon program. It supports "
					   "backgammon games\nwith other players, games against "
					   "computer engines like GNU bg and even\n"
					   "on-line games on the 'First Internet Backgammon Server'.");

/*
 * Main program doesn't do much - more or less standard stuff. Right
 * after creating a KBg object, control is passed to it.
 */
int main(int argc, char *argv[])
{
	KAboutData about(PROG_NAME, 0, ki18n("KBackgammon"), PROG_VERSION, ki18n(description),
			 KAboutData::License_GPL, ki18n("(C) 1999-2001 Jens Hoefkens"), ki18n(notice));

	about.addAuthor (ki18n("Jens Hoefkens"), ki18n("Author"),
			 "jens@hoefkens.com");

	about.addCredit (ki18n("Bo Thorsen"), ki18n("Initial anti-aliasing of the board"),
			 "gobo@imada.sdu.dk");
	
	about.addCredit (ki18n("Daren Sawkey"), ki18n("author of KBackgammon computer opponent"),
			 "daren@sawkey.net");

	about.addAuthor (ki18n("Daren Sawkey"), ki18n("Current maintainer"),
			 "daren@sawkey.net");
	about.setOrganizationDomain("kde.org");
	KCmdLineArgs::init(argc, argv, &about);

	KApplication application;
	KGlobal::locale()->insertCatalog("libkdegames");

	if (application.isSessionRestored())
		RESTORE(KBg)
	else {
		KBg *widget = new KBg;
		widget->readConfig();
		widget->show();
	}
	return application.exec();
}

