    /*

    $Id: kfax.h 628280 2007-01-29 17:22:59Z mkretz $

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1997 Bernd Johannes Wuebben
                       wuebben@math.cornell.edu


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#ifndef _KFAX_H_
#define _KFAX_H_

#include <kapplication.h>
#include <kmainwindow.h>
#include <kconfig.h>
#include <q3ptrlist.h>
//Added by qt3to4:
#include <QDragEnterEvent>
#include <QWheelEvent>
#include <QFrame>
#include <QResizeEvent>
#include <QDropEvent>
#include <kurl.h>

#define Pimage(p)	((XImage *)(p)->extra)

class KConfig;
class KStatusBar;
class QAction;
class KRecentFilesAction;
class KPrinter;
class QPainter;
class QScrollBar;

class MyApp:public KApplication {
public:
   virtual bool x11EventFilter( XEvent * );
};

class TopLevel : public KMainWindow
{
    Q_OBJECT


public:

    TopLevel( QWidget *parent=0, const char *name=0 );
    ~TopLevel();

    void openNetFile( const KUrl& _url);
    void saveNetFile( const KUrl& _url );

    static QList<TopLevel *> windowList;

    void handle_X_event(XEvent Event);
    void putImage();

protected:

    void resizeEvent( QResizeEvent * );
    void wheelEvent( QWheelEvent * );
    void dragEnterEvent( QDragEnterEvent * event );
    void dropEvent( QDropEvent * event );

    void updateActions();
    void updateGoActions();
    void updateZoomActions();

    void zoom( int );

    void readSettings();
    void writeSettings();
    void setupActions();
    void setupMenuBar();
    void setupToolBar();
    void setupEditWidget();
    void setupStatusBar();

    bool queryClose();

private:

    QFrame *faxqtwin;

    int indentID;
    QColor forecolor;
    QColor backcolor;

    KUrl fileUrl;
    KStatusBar *statusbar;

    KRecentFilesAction *actRecent;
    QAction *actAdd, *actSave, *actSaveAs, *actPrint;
    QAction *actSize, *actZoomIn, *actZoomOut, *actRotate, *actMirror;
    QAction *actFlip, *actNext, *actPrev, *actFirst, *actLast;

    int open_mode;

    KSharedConfigPtr config;

    QScrollBar *hsb;
    QScrollBar *vsb;

    void printIt( KPrinter &printer, QPainter &painter );
    bool loadAllPages( int &numpages, int &currentpage );

public slots:

    void faxOpen( const KUrl &  );
    void faxOpen();
    void faxAdd();
    void faxAdd( const KUrl & );
    void faxClose();
    void print();
    void zoomin();
    void zoomout();
    void actualSize();
    void resizeView();
    void faxSave();
    void faxSaveAs();

    void faxoptions();
    void rotatePage();
    void mirrorPage();
    void flipPage();
    void nextPage();
    void prevPage();
    void newPage();
    void firstPage();
    void lastPage();
    void uiUpdate();

    void openadd(QString filename);
    void FreeFax();
    void scrollHorz(int);
    void scrollVert(int);
};

void kfaxerror(const QString&, const QString&);
void loadfile(QString filename);

#endif // _KFAX_H_

