/***************************************************************************
 *   Copyright (C) 2005 by Stefan Kebekus                                  *
 *   kebekus@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include "pageInsertionWidget.h"
#include "kvs_debug.h"


PageInsertionWidget::PageInsertionWidget(PageNumber current, PageNumber numPages, const QString &url, const QString &filter,
					 QWidget *parent) : PageInsertionWidget_base(parent)
{
  // Paranoia saftey checks
  if (numPages == 0) {
    kError(kvs::djvu) << "PageInsertionWidget::PageInsertionWidget(..) called with numPages == 0" << endl;
    numPages = 1;
  }
  if (current == 0) {
    kError(kvs::djvu) << "PageInsertionWidget::PageInsertionWidget(..) called with current == 0" << endl;
    current = 1;
  }
  if (current > numPages) {
    kError(kvs::djvu) << "PageInsertionWidget::PageInsertionWidget(..) called with current == numPages" << endl;
    current = numPages;
  }

  //  fileWidget->setCaption(i18n("Insert Pages"));
  fileWidget->setUrl(url);
  fileWidget->setFilter(filter);
  fileWidget->setMode(KFile::LocalOnly | KFile::File | KFile::ExistingOnly);

  pageNr->setRange(1, numPages);
  pageNr->setValue(current);

  connect(fileWidget, SIGNAL(textChanged(const QString &)), this, SLOT(textChanged(const QString &)));
}


void PageInsertionWidget::textChanged(const QString &fname)
{
  emit have_valid_file(QFile::exists(fname));
}

#include "pageInsertionWidget.moc"

