/***************************************************************************
 *   Copyright (C) 2005 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#include <config.h>

#include <kdebug.h>
#include <klocale.h>

#include <QMouseEvent>

#include "documentPageCache.h"
#include "pdfWidget.h"
#include "hyperlink.h"
#include "pageView.h"
#include "selection.h"

#include "kvsprefs.h"

PdfWidget::PdfWidget(PageView* sv, DocumentPageCache* cache)
  : DocumentWidget(sv, cache)
{
}


void PdfWidget::mousePressEvent(QMouseEvent* e)
{
  // Safety check
  if (!pageNumber.isValid())
    return;

  // Check if the mouse is pressed on a source-hyperlink
  // source hyperlinks can be invoked with the Middle Mousebutton or alternatively
  // with Control+Left Mousebutton
  if (e->button() == Qt::MidButton || (e->button() == Qt::LeftButton && (e->modifiers() & Qt::ControlModifier)))
  {
    emit inverseSearch(pageNumber, inverseMap(e->pos()) * dataModel->resolution(), true);
    e->accept();
  }

  // Call implementation from parent
  DocumentWidget::mousePressEvent(e);
}


void PdfWidget::mouseMoveEvent(QMouseEvent* e)
{
  // Safety check
  if (!pageNumber.isValid())
    return;

  // Call the standard implementation
  DocumentWidget::mouseMoveEvent(e);

  if (dataModel->preferences()->tool() == KVSPrefs::EnumTool::Ruler)
    return;

  // Analyze the mouse movement only if no mouse button was pressed

  if ( e->modifiers() == Qt::NoModifier )
  {
    clearStatusBarTimer.stop();
    emit inverseSearch(pageNumber, inverseMap(e->pos()) / dataModel->resolution(), false);

    if (!clearStatusBarTimer.isActive())
    {
      // clear the statusbar after one second.
      clearStatusBarTimer.setSingleShot(true);
      clearStatusBarTimer.start(1000);
    }
  }
}


#include "pdfWidget.moc"
