// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
#include <config.h>

#include "documentWidget.h"
#include "ligaturePluginGUI.h"
#include "kprintDialogPage_pageoptions.h"
#include "kvs_debug.h"
#include "kvsprefs.h"
#include "renderedDocumentPagePrinter.h"
#include "zoomlimits.h"

#include <kfiledialog.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kparts/plugin.h>
#include <kprinter.h>
#include <kprocio.h>
#include <QApplication>
#include <QCheckBox>
#include <QObject>
//#include <QPaintDeviceMetrics>
#include <QSplitter>
#include "multipageadaptor.h"
#include <QtDBus/QtDBus>

//#define DEBUG_KMULTIPAGE


ligaturePluginGUI::ligaturePluginGUI(QObject* parent)
  : KParts::Plugin(parent)
{
  new MultiPageAdaptor(this);
  QDBusConnection::sessionBus().registerObject("/ligaturePluginGUI", this);
  // For reasons which I don't understand, the initialization of the
  // DCOPObject above does not work properly, the name is ignored. It
  // works fine if we repeat the name here. -- Stefan Kebekus
  // This is because of the virtual inheritance. Get rid of it (but it's BC, and this is a lib...) -- DF
  //setObjId("ligaturePluginGUI");

  parentWdg = 0;
}


ligaturePluginGUI::~ligaturePluginGUI()
{
  closeUrl();

  writeSettings();
}


void ligaturePluginGUI::readSettings()
{
  ;
}


void ligaturePluginGUI::writeSettings()
{
  ;
}


QString ligaturePluginGUI::name_of_current_file()
{
  return m_file;
}


bool ligaturePluginGUI::is_file_loaded(const QString& filename)
{
  return (filename == m_file);
}


bool ligaturePluginGUI::slotSave(const QString &fileName)
{
  if (fileName.isEmpty())
    return false;

  QFileInfo src(m_file);
  QFileInfo dest(fileName);

  if (src.absoluteFilePath() == dest.absoluteFilePath())
    return true;

  KProcIO proc;
  proc << "cp" << src.absoluteFilePath() << dest.absoluteFilePath();
  if (proc.start(KProcess::Block) == false) {
    KMessageBox::error(parentWdg, i18n("<qt>Could not start the <strong>cp</strong> copy command. The document is <strong>not</strong> saved.</qt>"),
                       i18n("Error saving document"));
    return false;
  }

  if (!proc.normalExit() || (proc.exitStatus() != 0)) {
    KMessageBox::error(parentWdg, i18n("<qt>Error saving the document. The document is <strong>not</strong> saved.</qt>"),
                       i18n("Error saving document"));
    return false;
  }

  return true;
}


void ligaturePluginGUI::setFile(bool)
{
  return;
}


bool ligaturePluginGUI::closeUrl()
{
#ifdef DEBUG_KMULTIPAGE
  kDebug(kvs::shell) << "ligaturePluginGUI::closeUrl()" << endl;
#endif

  if (renderer.isNull())
    return false;

  m_file = QString::null;
  m_url = KUrl();

  // Close the file.
  renderer->setFile(QString::null, KUrl());
  renderer->clear();

  enableActions(false);

  return true;
}


void ligaturePluginGUI::preferencesChanged()
{
  if (dataModel->preferences()->changeColors() && dataModel->preferences()->renderMode() == KVSPrefs::EnumRenderMode::Paper)
    renderer->setAccessibleBackground(true, dataModel->preferences()->paperColor());
  else
    renderer->setAccessibleBackground(false);
}


DocumentWidget* ligaturePluginGUI::createDocumentWidget(PageView *parent, DocumentPageCache *pageCache)
{
  DocumentWidget* documentWidget = new DocumentWidget(parent, pageCache);

  return documentWidget;
}

RenderedDocumentPagePixmap* ligaturePluginGUI::createDocumentPagePixmap(JobId id) const
{
  RenderedDocumentPagePixmap* page = new RenderedDocumentPagePixmap(id);
  page->setupObservers(dataModel);
  return page;
}


void ligaturePluginGUI::print()
{
  // Paranoid safety checks
  if (renderer.isNull())
    return;
  if (renderer->isEmpty())
    return;

  // Allocate the printer structure
  KPrinter *printer = getPrinter();
  if (printer == 0)
    return;

  // initialize the printer using the print dialog
  if ( printer->setup(parentWdg, i18n("Print %1", m_file.section('/', -1))) ) {
    // Now do the printing.
    QList<int> pageList = printer->pageList();
    if (pageList.isEmpty())
      printer->abort();
    else {
      printer->setCreator("ligature");
      printer->setDocName(m_file);
      RenderedDocumentPagePrinter rdpp(printer);

      // Obtain papersize information that is required to perform
      // the resizing and centering, if this is wanted by the user.
      Length paperWidth, paperHeight;
      paperWidth.setLength_in_mm(printer->widthMM());
      paperHeight.setLength_in_mm(printer->heightMM());

      QList<int>::ConstIterator it = pageList.begin();
      while (true) {
        SimplePageSize paper_s(paperWidth, paperHeight);

        // Printing usually takes a while. This is to keep the GUI
        // updated.
        qApp->processEvents();

        QPainter *paint = rdpp.getPainter();
        if (paint != 0) {
          // Before drawing the page, we figure out the zoom-value,
          // taking the "page sizes and placement" options from the
          // printer dialog into account
          double factual_zoom = 1.0;

          // Obtain pagesize information that is required to perform the
          // resizing and centering, if this is wanted by the user.
          SimplePageSize page_s = renderer->sizeOfPage(*it);

          paint->save();

          // Rotate the page, if appropriate. By default, page
          // rotation is enabled. This is also hardcoded into
          // KPrintDialogPage_PageOptions.cpp
          if ((page_s.isPortrait() != paper_s.isPortrait()) && (printer->option( "kde-ligature-rotatepage" ) != "false")) {
            paint->rotate(-90);
            paint->translate(-printer->resolution()*paperHeight.getLength_in_inch(), 0.0);
            paper_s = paper_s.rotate90();
          }

          double suggested_zoom = page_s.zoomToFitInto(paper_s);

          // By default, "shrink page" and "expand page" are off. This
          // is also hardcoded into KPrintDialogPage_PageOptions.cpp
          if ((suggested_zoom < 1.0) && (printer->option( "kde-ligature-shrinkpage" ) == "true"))
            factual_zoom = suggested_zoom;
          if ((suggested_zoom > 1.0) && (printer->option( "kde-ligature-expandpage" ) == "true"))
            factual_zoom = suggested_zoom;

          Length delX, delY;
          // By default, "center page" is on. This is also hardcoded
          // into KPrintDialogPage_PageOptions.cpp
          if (printer->option( "kde-ligature-centerpage" ) != "false") {
            delX = (paper_s.width() - page_s.width()*factual_zoom)/2.0;
            delY = (paper_s.height() - page_s.height()*factual_zoom)/2.0;
          }

          // Now draw the page.
          rdpp.setPageNumber(*it);

          double resolution = factual_zoom*printer->resolution();

          paint->translate(resolution*delX.getLength_in_inch(), resolution*delY.getLength_in_inch());
          //FIXME
          //renderer->drawPage(resolution, &rdpp);
          paint->restore();
        }
        ++it;
        if ((it == pageList.end()) || (printer->aborted() == true))
          break;

        printer->newPage();
      }
      // At this point the rdpp is destructed. The last page is then
      // printed.
    }
  }
  delete printer;
}


void ligaturePluginGUI::setRenderer(DocumentRenderer* _renderer)
{
  renderer = _renderer;
}


bool ligaturePluginGUI::openFile()
{
  if (renderer.isNull()) {
    kError(kvs::shell) << "ligaturePluginGUI::openFile() called when no renderer was set" << endl;
    return false;
  }

  bool r = renderer->setFile(m_file, m_url);
  if (!r)
    m_file = QString::null;
  setFile(r);
  return r;
}


bool ligaturePluginGUI::openUrl(const QString &filename, const KUrl &base_url)
{
  m_file = filename;
  m_url = base_url;

  bool success = openFile();

  if (success)
  {
    dataModel->setNumberOfPages(renderer->totalPages());
  }

  return success;
}


void ligaturePluginGUI::enableActions(bool fileLoaded)
{
  Q_UNUSED(fileLoaded);
}


KPrinter *ligaturePluginGUI::getPrinter(bool enablePageSizeFeatures)
{
    // Allocate a new KPrinter structure, if necessary
  KPrinter *printer = new KPrinter(true);
  if (printer == 0) {
    kError(kvs::shell) << "ligaturePluginGUI::getPrinter(..): Cannot allocate new KPrinter structure" << endl;
    return 0;
  }

  // Allocate a new KPrintDialogPage structure and add it to the
  // printer, if the ligaturePluginGUI implementation requests that
  if (enablePageSizeFeatures == true) {
    KPrintDialogPage_PageOptions *pageOptions = new KPrintDialogPage_PageOptions();
    if (pageOptions == 0) {
      kError(kvs::shell) << "ligaturePluginGUI::getPrinter(..): Cannot allocate new KPrintDialogPage_PageOptions structure" << endl;
      delete printer;
      return 0;
    }
    printer->addDialogPage( pageOptions );
  }

  // Feed the printer with useful defaults and information.
  printer->setPageSelection( KPrinter::ApplicationSide );
  printer->setCurrentPage( dataModel->currentPageNumber() );
  printer->setMinMax( 1, dataModel->numberOfPages() );
  printer->setFullPage( true );

  // If pages are marked, give a list of marked pages to the printer.
  QString range = dataModel->selectedPageRange();
  printer->setOption("kde-range", range);

  return printer;
}

#include "ligaturePluginGUI.moc"
