// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
//
// sizePreview.h
//
// Part of LIGATURE - A framework for multipage text/gfx viewers
//
// (C) 2002 Stefan Kebekus
// Distributed under the GPL

#ifndef SIZEPREVIEW_H
#define SIZEPREVIEW_H

#include <QPixmap>
#include <QWidget>

class QPaintEvent;
class QResizeEvent;
class SimplePageSize;


class SizePreview : public QWidget
{
  Q_OBJECT

public:
  SizePreview(QWidget* parent, Qt::WFlags f=0);

public slots:
  // Sets the size.
  void setSize(const SimplePageSize&);

  // or = 0 means "Portrait", anything else means "Landscape"
  void setOrientation(int ori);

protected:
  void paintEvent(QPaintEvent*);
  void resizeEvent(QResizeEvent*);

private:
  int orientation; // 0 = portrait, other = landscape

  // Both must be positive at all times!
  float _width; // in mm
  float _height; // in mm

  QPixmap pixmap;
};

#endif
