// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
/***************************************************************************
 *   Copyright (C) 2005 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   Copyright (C) 2006 by Stefan Kebekus                                  *
 *   kebekus@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef TABLEOFCONTENTS_H
#define TABLEOFCONTENTS_H

#include "anchor.h"
#include "dataView.h"
#include "pageNumber.h"

#include <k3listview.h>

#include <QPixmap>
#include <Q3PtrList>

class Bookmark;


class TocItem : public K3ListViewItem
{
public:
  TocItem(TocItem* parent);
  TocItem(Q3ListView* parent);

  void setAnchor(const Anchor & _anchor) { anchor = _anchor; }
  Anchor getAnchor() { return anchor; }

private:
  Anchor anchor;
};


class TableOfContents : public K3ListView, public DataView
{
Q_OBJECT

public:
  TableOfContents(QWidget* parent);

  /** destructor
      
  @warning The destructor uses the pointer to the DataModel set in
  setupObservers in order to save its layout to the configuration
  file. It is therefore important that the TableOfContents is deleted
  *before* the dataModel is deleted, otherwise the program will
  segfault.
  */
  virtual ~TableOfContents();
  
  void setContents(const Q3PtrList<Bookmark>& bookmarks);

  virtual QSize sizeHint() const { return QSize(); }

  /** Set the DataModel
      
  @warning The DataModel is used by many methods of the
  TableOfContents class, including the destructor. It is therefore
  important that the TableOfContents is deleted *before* the dataModel
  is deleted, otherwise the program will segfault.
  */
  virtual void setupObservers(DataModel*);

public slots:
  virtual void clear();

  void writeSettings();
  void readSettings();

private:
  void addItems(const Q3PtrList<Bookmark>& bookmarks, TocItem* parent = 0);

private slots:
  void setCurrentPage();
  void itemClicked(Q3ListViewItem*);
  void computeCurrentChapter();

private:
  QPixmap currentChapterIcon;

  TocItem* currentChapter;

  PageNumber currentPageNumber;
};

#endif
