/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001-2002 Michael Goffioul <kdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef POSTERPREVIEW_H
#define POSTERPREVIEW_H

#include <QFrame>
#include <QList>

class KProcess;

class PosterPreview : public QFrame
{
	Q_OBJECT
public:
	PosterPreview( QWidget *parent = 0 );
	PosterPreview( const QString& postersize, const QString& mediasize, QWidget *parent = 0 );
	~PosterPreview();

public Q_SLOTS:
	void setPosterSize( int );
	void setPosterSize( const QString& );
	void setMediaSize( int );
	void setMediaSize( const QString& );
	void setCutMargin( int );
	void updatePoster();
	void setSelectedPages( const QString& );

Q_SIGNALS:
	void selectionChanged( const QString& );

protected:
	void parseBuffer();
	void paintEvent( QPaintEvent * );
	void init();
	void setDirty();
	void mouseMoveEvent( QMouseEvent* );
	void mousePressEvent( QMouseEvent* );
	void emitSelectedPages();

protected Q_SLOTS:
	void slotProcessStderr( KProcess*, char*, int );
	void slotProcessExited( KProcess* );

private:
	int m_rows, m_cols;
	int m_pw, m_ph; // page size
	int m_mw, m_mh; // cur margins
	QRect m_posterbb; // poster bounding box (without any margin)
	KProcess *m_process;
	QString m_buffer;
	QString m_postersize, m_mediasize;
	int m_cutmargin;
	bool m_dirty;
	QRect m_boundingrect;
	QList<int> m_selectedpages;
};

#endif /* POSTERPREVIEW_H */
