/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <kdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef	CUPSDDIALOG_H
#define	CUPSDDIALOG_H

#include <kpagedialog.h>
#include <QtCore/QList>

class CupsdPage;
struct CupsdConf;

class CupsdDialog : public KPageDialog
{
	Q_OBJECT
public:
	explicit CupsdDialog(QWidget *parent = 0, const char *name = 0);
	~CupsdDialog();

	bool setConfigFile(const QString& filename);

	static KDE_EXPORT bool configure(const QString& filename = QString(), QWidget *parent = 0, QString *errormsg = 0);
	static KDE_EXPORT bool restartServer(QString& msg);
	static int serverPid();
	static int serverOwner();

protected Q_SLOTS:
	void slotOk();
	void slotUser1();

protected:
	void addConfPage(CupsdPage*);
	void constructDialog();
	void restartServer();

private:
	QList<CupsdPage*>	pagelist_;
	CupsdConf		*conf_;
	QString			filename_;
};

#endif
