/* This file is part of Noatun

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "hardwarevc.h"

#ifdef HARDWARE_VOLUME

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <qfile.h>

namespace Noatun
{

HardwareVC::HardwareVC(const QString &mixerDevice)
{
	if (mixerDevice.isNull())
		fd = ::open("/dev/mixer", O_RDWR);
	else
		fd = ::open(QFile::encodeName(mixerDevice), O_RDWR);

	if (fd > -1)
	{
		int devmask, recmask, i_recsrc, stereodevs;
		// Mixer is open. Now define properties
		if (ioctl(fd, SOUND_MIXER_READ_DEVMASK, &devmask) == -1) { fd=-1; return; }
		if (ioctl(fd, SOUND_MIXER_READ_RECMASK, &recmask) == -1) { fd=-1; return; }
		if (ioctl(fd, SOUND_MIXER_READ_RECSRC, &i_recsrc) == -1) { fd=-1; return; }
		if (ioctl(fd, SOUND_MIXER_READ_STEREODEVS, &stereodevs) == -1) { fd=-1; return; }
		if (!devmask) { fd=-1; return; }
	}
}

HardwareVC::~HardwareVC()
{
	if (fd > -1)
		::close(fd);
}

void HardwareVC::setVolume(int percent)
{
	if (fd > -1)
	{
		percent += (percent << 8);
		ioctl(fd, MIXER_WRITE(4), &percent);
	}
}

int HardwareVC::volume() const
{
	int volume, left, right;
	left = 100;

	if (fd > -1)
	{
		if (ioctl(fd, MIXER_READ(4), &volume) != -1)
		{
			left = volume & 0x7f;
			right = (volume >> 8) & 0x7f;
			left = (left + right) / 2;
		}
	}
	return left;
}

} // namespace Noatun

#endif // HARDWARE_VOLUME
