/* This file is part of Noatun

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef N_HARDWAREVC_H
#define N_HARDWAREVC_H

#include <qstring.h>

#define HARDWARE_VOLUME

#if defined(__osf__)
	#undef HARDWARE_VOLUME
#elif defined(__linux__)
	#include <sys/soundcard.h>
#elif defined(__FreeBSD__)
	#include <sys/soundcard.h>
#elif defined(__NetBSD__)
	#include <soundcard.h>
#elif defined(___SOMETHING_UNKNOWN__)
	#include <sys/soundcard.h>
#elif defined(_UNIXWARE)
	#include <sys/soundcard.h>
#else
	#undef HARDWARE_VOLUME
#endif

#ifdef HARDWARE_VOLUME
namespace Noatun
{

class HardwareVC
{
public:
	explicit HardwareVC(const QString &mixerDevice = QString());
	~HardwareVC();
	void setVolume(int percent);
	int volume() const;
private:
	int fd;
}; // class HardwareVC

} // namespace Noatun
#endif

#endif
