/***************************************************************************
                     A simple database-driven playlist for Noatun
                    ---------------------------------------------
    begin                : 24.05.2005
    copyright            : (C) 2005 by Stefan Gehn
    email                : Stefan Gehn <mETz81@web.de>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SIMPLELISTVIEW_H
#define SIMPLELISTVIEW_H

#include <klistview.h>
#include <qmap.h>
#include <kurl.h>

class KActionMenu;
class KPopupMenu;

class SimplePlaylist;
class SimplePlaylistItem;
class SimpleListViewItem;
class DBItem;


class SimpleListView : public KListView
{
friend class SimpleListViewItem;
Q_OBJECT
public:
	SimpleListView(SimplePlaylist *pl, QWidget *parent, const char *name);
	~SimpleListView();

	void refresh();

	void setCurrentByItemId(int id);
	int currentItemId() const;
	int nextItemId() const;
	int previousItemId() const;
	int firstItemId() const;

	void sort(); //virtual

	KActionMenu *viewColumnsAction() const;

public Q_SLOTS:
	void deleteSelected();
	void executeCurrent();

private Q_SLOTS:
	void slotItemInserted(const DBItem &item);
	void slotItemDeleted(int);
	void slotItemUpdated(int);
	void slotItemUpdatedLength(int id, int newLength);
	void slotExecuted(QListViewItem *qlvi);
	void slotMoved(QListViewItem *, QListViewItem *, QListViewItem *);
	void slotDropped(QDropEvent*, QListViewItem*);
	void slotDisableSorting();
	void slotToggleColumns(int col);
	void slotColumnOrderChanged(int, int from, int to);
	void slotDropMenuActivated(int item);

Q_SIGNALS:
	void executedItem(int);

protected:
	virtual QDragObject *dragObject();
	virtual bool acceptDrag (QDropEvent *) const;
	virtual bool eventFilter(QObject *watched, QEvent *e);
	SimpleListViewItem *currentListItem() const;
	int leftColumnIndex() const;

protected:
	/// Maps db id to listviewitems
	QMap<int, SimpleListViewItem *> map;

private:
	void restoreViewLayout();
	void saveViewLayout();
	void setCurrentItem(SimpleListViewItem *item);
	void updatePosition(SimpleListViewItem *lvi, int next);
	int leftMostColumnIndex() const;
	bool isColumnVisible(int col) const;
	void hideColumn(int col);
	void showColumn(int col);

private:
	SimpleListViewItem *mCurrentListItem;
	SimplePlaylist *playlist;
	KActionMenu *mViewColumnsAction;
	KPopupMenu *mHeaderMenu;
	int mLeftColumnIndex;
	/// Needed for async drop operations
	KURL::List mDroppedUrlsList;
	KPopupMenu *mDropMenu;
	SimpleListViewItem *mDropAfterItem;
}; // END class SimpleListView


// ==================================================================================================


class SimpleListViewItem : public KListViewItem
{
friend class SimpleListView;
public:
	enum Column
	{
		TitleCol = 0, ArtistCol, AlbumCol, TrackCol, GenreCol,
		YearCol, LengthCol, BitrateCol, CommentCol
	};

	/// Constructor
	SimpleListViewItem(SimpleListView *parent, const DBItem &item);

	/// DB-id of this listviewitem
	int id() const;
	const KURL &url() const;
	void itemUpdated(const DBItem &item);

	static int lastColumnIndex() { return CommentCol; }

	virtual void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment);
	virtual void setup();

	virtual int width(const QFontMetrics &fm, const QListView *lv, int c) const;
	virtual const QPixmap *pixmap(int col) const;

protected:
	void setLength(int len);

private:
	int mId;
	KURL mURL;
}; // END class SimpleListViewItem

#endif
