/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    Based on code by Fluendo:
    Copyright (C) 2006 Wim Taymans <wim@fluendo.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "gstoptions.h"
#include <kgenericfactory.h>
#include <kconfiggroup.h>

K_EXPORT_COMPONENT_FACTORY(kcm_phonongst, KGenericFactory<GstOptions>("kcm_phonongst"))

GstOptions::GstOptions(QWidget *parent, const QStringList &args)
    : KCModule(KGenericFactory<GstOptions>::componentData(), parent, args)
{
    setupUi(this);

    m_config = KSharedConfig::openConfig("gstbackendrc");
    connect(m_ossCheckbox, SIGNAL(toggled(bool)), SLOT(changed()));
    connect(m_viewPipelineCheckbox, SIGNAL(toggled(bool)), SLOT(changed()));

    load();
}

void GstOptions::load()
{
    KConfigGroup cg(m_config, "Settings");
    m_ossCheckbox->setChecked(cg.readEntry("showOssDevices", false));
    m_viewPipelineCheckbox->setChecked(cg.readEntry("showPipeline", false));
}

void GstOptions::save()
{
    KConfigGroup cg(m_config, "Settings");
    cg.writeEntry("showOssDevices", m_ossCheckbox->isChecked());
    cg.writeEntry("showPipeline", m_viewPipelineCheckbox->isChecked());
}

void GstOptions::defaults()
{
    m_ossCheckbox->setChecked(false);
    m_viewPipelineCheckbox->setChecked(false);
}

#include "gstoptions.moc"