/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    Based on code by Fluendo:
    Copyright (C) 2006 Wim Taymans <wim@fluendo.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "pipeline.h"

#include "qbtgstreamer/qbtgstreamerbin.h"

#include <libxml/globals.h>
#include <libxml/parser.h>

#include <QString>
#include <QByteArray>

#include <kdebug.h>
#include <kconfiggroup.h>

namespace Phonon
{
namespace GStreamer
{

Pipeline *Pipeline::m_instance;

Pipeline::Pipeline(const KSharedConfigPtr &cfg)
{
    m_config = KSharedConfig::openConfig("gstbackendrc");//cfg;

    m_instance = this;
    m_pipeline = new QbtGStreamerPipeline("Phonon GStreamer Pipeline");
    m_pipeline->setState(QbtGStreamerStatePaused);

    KConfigGroup cg(m_config, "Settings");
    m_showPipeline = cg.readEntry("showPipeline", false);
}

Pipeline::~Pipeline()
{
}

Pipeline *Pipeline::instance()
{
    if (!m_instance)
        m_instance = new Pipeline;

    return m_instance;
}

bool Pipeline::add(QbtGStreamerElement *element)
{
    kDebug(611) << this << ": adding element " << element->objectName() << endl;

    bool result = m_pipeline->addElement(element);

    savePipeline();

    return result;
}

bool Pipeline::remove(QbtGStreamerElement *element)
{    
    kDebug(611) << this << ": removing element " << element->objectName() << endl;

    bool result = m_pipeline->removeElement(element);

    savePipeline();

    return result;
}

void Pipeline::play()
{
    kDebug(611) << k_funcinfo << endl;

    m_pipeline->setState(QbtGStreamerStatePlaying);
}

void Pipeline::savePipeline()
{

    KConfigGroup cg(m_config, "Settings");
    m_showPipeline = cg.readEntry("showPipeline", false);

    xmlDocPtr x = gst_xml_write (GST_ELEMENT(m_pipeline->gstPipeline()));

    if (!x)
        return;

    QDomDocument doc;

    xmlChar *mem;
    int size;

    
    xmlDocDumpMemory( x, &mem, &size );

    QString resultString = QString::fromUtf8((char *)mem);
    //resultString = QString::fromUtf8( QByteArray( ( char * )( mem )/*, size + 1*/ ) );

    kDebug(611) << "New pipeline xml:" << endl;
    kDebug(611) << "-----------------" << endl;
    kDebug(611) << "size = " << size << endl;
    kDebug(611) << "resultstring size = " << resultString.size() << endl;

    QString err;

    if (doc.setContent(resultString, &err))
        kDebug(611) << "doc is fine!" << endl;
    else
        kWarning(611) << "doc doesn't feel good! Error = " << err << endl;

    xmlFree( mem );
    xmlFreeDoc( x );

    PipelineView *v;

    kDebug() << "############### m_showPipeline = " << m_showPipeline << endl;
    if (m_showPipeline) {
        v = PipelineView::instance();
        v->setXmlDoc(doc);
        v->show();
    } 
#if 0
else {
        v->hide();
        delete v;
    }
#endif
}




}} // Phonon::GStreamer
