/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    Based on code by Fluendo:
    Copyright (C) 2006 Wim Taymans <wim@fluendo.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "paramitem.h"

#include <QString>
#include <QGraphicsScene>
#include <QRectF>
#include <QFontMetrics>
#include <QFont>
#include <QtGlobal>
#include <QPixmap>
#include <QPixmapCache>
#include <QImage>
#include <QPainterPath>
#include <QDomDocument>
#include <QPainter>

#include <kdebug.h>

namespace Phonon
{
namespace GStreamer
{

QPixmap ParamItem::cached(const QString &img)
{
    if (QPixmap *p = QPixmapCache::find(img))
        return *p;

    QPixmap pm;
    pm = QPixmap::fromImage(QImage(img), Qt::OrderedDither | Qt::OrderedAlphaDither);
    if (pm.isNull())
        return QPixmap();

    QPixmapCache::insert(img, pm);
    return pm;
}

ParamItem::ParamItem(const QDomElement &element, QGraphicsItem *parent)
    : QGraphicsItem(parent)
{
    m_paramName = element.firstChildElement("gst:name").text();
    m_paramValue = element.firstChildElement("gst:value").text();

    titleStretch = cached(":/images/title_stretch.png");
    titleLeft = cached(":/images/title_cap_left.png");
    titleRight = cached(":/images/title_cap_right.png");
}

QRectF ParamItem::boundingRect() const
{
    QFont font;
    QFontMetrics fm(font);

    int name_txt_width = fm.width(m_paramName) + 20;
    int value_txt_width = fm.width(m_paramValue) + 20;
    int total_width = titleLeft.width() + name_txt_width + value_txt_width + titleRight.width();

    QRect f(0, 0, total_width, titleStretch.height());
    return f;
}

void ParamItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(option)
    Q_UNUSED(widget)

    QRect r = boundingRect().toRect();

    painter->save();

    painter->setRenderHint(QPainter::Antialiasing);

    QFont font;
    QFontMetrics fm(font);

    int name_txt_width = fm.width(m_paramName) + 20;
    painter->drawPixmap(0, 0, titleLeft);

    QRect tileRectName = QRect(titleLeft.width(), 0, name_txt_width, titleStretch.height());

    painter->drawTiledPixmap(tileRectName, titleStretch);

    int opacity = 31;
    painter->setPen(QColor(0, 0, 0, opacity));
    painter->drawText(tileRectName.translated(0, 1),
                      Qt::AlignVCenter | Qt::AlignHCenter, m_paramName);
    painter->drawText(tileRectName.translated(2, 1),
                      Qt::AlignVCenter | Qt::AlignHCenter, m_paramName);
    painter->setPen(QColor(0, 0, 0, opacity * 2));
    painter->drawText(tileRectName.translated(1, 1),
                      Qt::AlignVCenter | Qt::AlignHCenter, m_paramName);
    painter->setPen(Qt::white);
    painter->drawText(tileRectName, Qt::AlignVCenter | Qt::AlignHCenter, m_paramName);

    int value_txt_width = fm.width(m_paramValue) + 20;

    QRect tileRectValue = QRect(titleLeft.width() + tileRectName.width(), 0, value_txt_width, titleStretch.height());

    painter->drawTiledPixmap(tileRectValue, titleStretch);

    painter->setBrush(QColor(255, 255, 255, 70));
    painter->setPen(Qt::NoPen);
    painter->drawRect(tileRectValue);

    painter->drawPixmap(titleLeft.width() + tileRectName.width() + tileRectValue.width(), 0, titleRight);

    painter->setPen(QColor(0, 0, 0, opacity));
    painter->drawText(tileRectValue.translated(0, 1),
                      Qt::AlignVCenter | Qt::AlignHCenter, m_paramValue);
    painter->drawText(tileRectValue.translated(2, 1),
                      Qt::AlignVCenter | Qt::AlignHCenter, m_paramValue);
    painter->setPen(QColor(0, 0, 0, opacity * 2));
    painter->drawText(tileRectValue.translated(1, 1),
                      Qt::AlignVCenter | Qt::AlignHCenter, m_paramValue);
    painter->setPen(Qt::white);
    painter->drawText(tileRectValue, Qt::AlignVCenter | Qt::AlignHCenter, m_paramValue);

    painter->restore();
}

}} // Phonon::GStreamer
