/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerghostpad.h"

QbtGStreamerGhostPad::QbtGStreamerGhostPad(const QString &name, QbtGStreamerPad *target)
{
    m_pad = gst_ghost_pad_new(name.toLocal8Bit().data(), target->gstPad());
}

QbtGStreamerPad *QbtGStreamerGhostPad::target()
{
    GstPad *targetPad = gst_ghost_pad_get_target(GST_GHOST_PAD(m_pad));

    if (!targetPad)
        return 0;

    QbtGStreamerPad *target = new QbtGStreamerPad;
    target->setGstPad(targetPad);

    return target;
}
