#include "qbtgstreamermixer.h"

QbtGStreamerMixer::QbtGStreamerMixer()
{
}

QbtGStreamerMixer::~QbtGStreamerMixer()
{
}

void QbtGStreamerMixer::setGstMixer(GstMixer *mixer)
{
    m_mixer = mixer;
}

GstMixer *QbtGStreamerMixer::gstMixer()
{
    return m_mixer;
}

QList<QbtGStreamerMixerTrack*> QbtGStreamerMixer::tracks()
{
    QList<QbtGStreamerMixerTrack*> returnList;

    const GList* list;
    const GList *item;

    if(!m_mixer)
        return QList<QbtGStreamerMixerTrack*>();

    list = gst_mixer_list_tracks(m_mixer);

    for(item = list; item != NULL; item = item->next) {
        QbtGStreamerMixerTrack* btMixerTrack = new QbtGStreamerMixerTrack;
        btMixerTrack->setGstMixerTrack(GST_MIXER_TRACK(item->data));
        returnList.append(btMixerTrack);
    }

    return returnList;
}
