/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMEROBJECT
#define QBTGSTREAMEROBJECT

#include <QObject>
#include <QString>

#include <gst/gst.h>
#include "qbtgstreamer_export.h"

#define QBTGSTREAMER_NULL static_cast<gpointer>(0)
#define QBTGSTREAMER_SLOT(f) (void *)&f

enum QbtGStreamerObjectFlags
{
  QbtGStreamerObjectDisposing = (1<<0),
  QbtGStreamerObjectFloating = (1<<1),
  /* padding */
  QbtGStreamerObjectFlagLast = (1<<4)
};

class QBTGSTREAMER_EXPORT QbtGStreamerObject : public QObject
{
Q_OBJECT
public:
    QbtGStreamerObject();
    QbtGStreamerObject(const QbtGStreamerObject&);
    QbtGStreamerObject& operator= (const QbtGStreamerObject&);
    ~QbtGStreamerObject();

    virtual void setProperty(const QString&, const QString&);

    void connectSignal(const QString& signal, void *slot);

    QString name();

    void setGstObject(GstObject *object);
    GstObject *gstObject();

protected:
    GstObject *m_object;
};

#endif
