/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERTYPEFINDFACTORY
#define QBTGSTREAMERTYPEFINDFACTORY

#include "qbtgstreamerpluginfeature.h"
#include "qbtgstreamerelement.h"
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

#include <QList>
#include <QString>
#include <QStringList>

class QBTGSTREAMER_EXPORT QbtGStreamerTypeFindFactory : public QbtGStreamerPluginFeature
{
public:
    QbtGStreamerTypeFindFactory();
    ~QbtGStreamerTypeFindFactory();

    static QList<QbtGStreamerTypeFindFactory *> list();

    QStringList extensions();

    void setGstTypeFindFactory(GstTypeFindFactory* factory);
    bool fromPluginFeature(QbtGStreamerPluginFeature* feature);
    GstTypeFindFactory* gstTypeFindFactory();

private:
    //static QbtGStreamerTypeFindFactory* s_instance;

    GstTypeFindFactory* m_factory;
};

#endif

