/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */ 

#ifndef HOSTLIST_H
#define HOSTLIST_H

#include "hostlistitem.h"

#include <QAbstractTableModel>
#include <QCheckBox>
#include <QList>


class HostList : public QAbstractTableModel
{
Q_OBJECT

public:
	HostList(QObject* parent);
	~HostList();

	int rowCount(const QModelIndex & parent = QModelIndex()) const;
	QVariant data(const QModelIndex & index, int role = Qt::DisplayRole) const;
	QVariant headerData( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
	bool setData(const QModelIndex & index, const QVariant & value, int role = Qt::EditRole);
	int columnCount(const QModelIndex & parent = QModelIndex()) const;
	Qt::ItemFlags flags ( const QModelIndex & index ) const;
	bool insertRows(int position, int rows, const QModelIndex &index = QModelIndex());
//	bool removeRows(int position, int rows, const QModelIndex &index = QModelIndex());


	void addBranches();
private:

	QList<HostListItem> m_hostList;
	DCOPClient* m_client;
	DCOPCString m_dcopAppId;

public slots:
	void addRow();
};

#endif

