/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */ 


#ifndef Phonon_NMM_DCOPCONFIGPROXYIFACE_H
#define Phonon_NMM_DCOPCONFIGPROXYIFACE_H

#include <dcopobject.h>

#include <QList>
#include <QStringList>

//nmm stuff
#include "nmm/base/registry/NodeDescription.hpp"
using namespace NMM;

namespace Phonon
{
namespace nmm
{


class KDE_EXPORT DCOPConfigProxyIface : virtual public DCOPObject
{
	K_DCOP
	k_dcop:
	virtual bool addBranch(const int streamId, QString& sink_nd) = 0;
	virtual bool addRemoteBranch(const int streamId, QString& sink_nd, QString& hostname) = 0;
	virtual QStringList getBranch(int id) = 0;
	virtual QList<int> getBranchIds() = 0;
	virtual bool removeBranch(int id) = 0;
	//TODO maybe add updateBranch(...)
};

}}
#endif //Phonon_NMM_DCOPCONFIGPROXYIFACE_H
// vim: sw=4 ts=4 tw=80 noet
