/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
#ifndef Phonon_NMM_VOLUMEFADEREFFECT_H
#define Phonon_NMM_VOLUMEFADEREFFECT_H

#include <QTime>
#include "audioeffect.h"
#include <phonon/volumefadereffect.h>

namespace Phonon
{
namespace nmm
{

	class VolumeFaderEffect : public AudioEffect
	{
		Q_OBJECT
		public:
			VolumeFaderEffect( QObject* parent );
			~VolumeFaderEffect();

			Q_INVOKABLE float volume() const;
			Q_INVOKABLE void setVolume( float volume );
			Q_INVOKABLE Phonon::VolumeFaderEffect::FadeCurve fadeCurve() const;
			Q_INVOKABLE void setFadeCurve( Phonon::VolumeFaderEffect::FadeCurve curve );
			Q_INVOKABLE void fadeTo( float volume, int fadeTime );

		private:
			float m_volume;
			float m_endvolume;
			int m_fadeTime;
			QTime m_fadeStart;
			Phonon::VolumeFaderEffect::FadeCurve m_fadeCurve;
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_VOLUMEFADEREFFECT_H
// vim: sw=4 ts=4 tw=80 noet
