/* This file is part of Noatun

  Copyright 2001-2006 by Charles Samuels <charles@kde.org>
  Copyright 2003-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "app.h"
#include "generalprefs.h"
#include "pluginmodule.h"

#include "noatun/config.h"
#include "noatun/frontend.h"
#include "noatun/global.h"
#include "noatun/playlist.h"
#include "noatun/pluginloader.h"
#include "noatun/preferencesdialog.h"

#include <kcmdlineargs.h>
#include <kglobal.h>
#include <kxmlguiwindow.h>
#include <kdebug.h>


NoatunApplication::NoatunApplication() : KUniqueApplication(true, true)
{
	kDebug(66666) << "BEGIN ========================";

	mInstance = new Noatun::Global(this, KGlobal::mainComponent());

	connect(mInstance, SIGNAL(shutdown()), SLOT(quit()));
	connect(mInstance->frontend(), SIGNAL(newFrontend()), SLOT(slotNewFrontend()));

	mGeneralPrefs = new GeneralPrefsPage(mInstance);
	mInstance->preferencesDialog()->addPreferencesPage(mGeneralPrefs);

	mPluginPrefs  = new PluginSelectorPage(mInstance);
	mInstance->preferencesDialog()->addPreferencesPage(mPluginPrefs);

	// TODO: Maybe do this in NInstance constructor via singleShot() timer?
	mInstance->pluginHandler()->loadAll();

	kDebug(66666) << "END ==========================";
}


NoatunApplication::~NoatunApplication()
{
	delete mGeneralPrefs;
	delete mPluginPrefs;
	kDebug(66666) << "This is the very end, really :)";
}


int NoatunApplication::newInstance()
{
	KUniqueApplication::newInstance();
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	if (args->count() > 0)
	{
		KUrl::List urls;
		for (int i=0; i < args->count(); i++)
			urls.append(args->url(i));
		args->clear();
		mInstance->playlist()->addFile(urls, mInstance->config()->clearOnOpen(), true);
	}

	return 0;
}


void NoatunApplication::slotNewFrontend()
{
	setTopWidget(mInstance->frontend()->mainWindow());
}

#include "app.moc"
