/* This file is part of Noatun

  Copyright 2000-2006 Charles Samuels <charles@kde.org>
  Copyright 2000-2002 Neil Stevens <neil@qualityassistant.com>
  Copyright 2003-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "app.h"

#include "noatun/version.h"

#include <kcmdlineargs.h>
#include <klocale.h>
#include <kaboutdata.h>

static const char appName[]     = "noatun";
static const char progName[]    = I18N_NOOP("Noatun");
static const char version[]     = NOATUN_VERSION;
static const char description[] = I18N_NOOP("Three-eyed jellyfish sounds good");
static const char copyright[]   = I18N_NOOP("(c) 2000-2007, The Noatun Developers");
static const char freeText[]    = I18N_NOOP("From a norse myth: Noatun is the home of Njord who is the leader of the Vanir.");
static const char homepage[]    = "http://noatun.kde.org";


extern "C" KDE_EXPORT int kdemain(int argc, char **argv)
{
	KAboutData aboutData(appName, 0, ki18n(progName), version, ki18n(description),
		KAboutData::License_BSD, ki18n(copyright), ki18n(freeText), homepage);

	aboutData.addAuthor(ki18n("Charles Samuels"),
		ki18n("Noatun Developer"),
		"charles@kde.org");
	aboutData.addAuthor(ki18n("Stefan Gehn"),
		ki18n("Maintainer, K-Jöfol Skin Support, EXTM3U playlist loading,\n" \
			"Phonon, GStreamer and aKode engine"),
		"metz@gehn.net",
		"http://metz.gehn.net");
	aboutData.addAuthor(ki18n("Stefan Westerfeld"),
		ki18n("Patron of the aRts"),
		"stefan@space.twc.de");
	aboutData.addAuthor(ki18n("Martin Vogt"),
		ki18n("MPEG Codec and OGG Vorbis Support"),
		"mvogt@rhrk.uni-kl.de");
	aboutData.addAuthor(ki18n("Malte Starostik"),
		ki18n("HTML playlist export"),
		"malte@kde.org");
	aboutData.addAuthor(ki18n("Nikolas Zimmermann"),
		ki18n("HTML playlist export"),
		"wildfox@kde.org");
	aboutData.addAuthor(ki18n("Stefan Schimanski"),
		ki18n("Kaiman Skin Support"),
		"1Stein@gmx.de");
	aboutData.addCredit(ki18n("Bill Huey"),
		ki18n("Special help with the equalizer"));

	KCmdLineArgs::init(argc, argv, &aboutData);

	KCmdLineOptions options;
	options.add("+[URL]", ki18n("Files/URLs to open"));
	KCmdLineArgs::addCmdLineOptions(options);
	NoatunApplication::addCmdLineOptions();

	NoatunApplication app;

	return app.exec();
}
