/* This file is part of Noatun

  Copyright 2000-2006 by Charles Samuels <charles@kde.org>
  Copyright 2000-2001 by Neil Stevens <neil@qualityassistant.com>
  Copyright 2002-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef N_PREFERENCESPAGE_H
#define N_PREFERENCESPAGE_H

#include <noatun/noatun_export.h>

#include <kpagewidgetmodel.h>

namespace Noatun
{
class Global;
class Plugin;

/**
 * @brief A page that can be shown in Noatun::PreferencesDialog
 * @author Stefan Gehn \<metz AT gehn DOT net\>
 *
 * This class is similar to KCModule except that it does not involve
 * extra libraries for every single page.
 *
 * @see PreferencesDialog::addPreferencesPage()
 * @see PreferencesDialog::removePreferencesPage()
 **/
class NOATUN_EXPORT PreferencesPage : public KPageWidgetItem
{
Q_OBJECT
public:
	/**
	 * @brief Creates a new preferences page
	 * @param widget The widget that is shown as page in Noatun::PreferencesDialog
	 * @param name   The localized string that is show in the navigation view
	 *               of Noatun::PreferencesDialog.
	 * @note You will have to add the page to the preferences dialog
	 *       using PreferencesDialog::addPreferencesPage()
	 **/
	PreferencesPage(QWidget *widget, const QString &name);

Q_SIGNALS:
	/**
	 * @brief Indicate that the state of the page contents has changed.
	 *
	 * This signal is emitted whenever the state of the configuration shown in
	 * the page changes. It allows the preferences dialog to keep track of unsaved
	 * changes.
	 **/
	void changed(bool state);

public Q_SLOTS:
	/**
	 * Saves all options for this page.
	 **/
	virtual void save() = 0;
	/**
	 * Loads all options for this page.
	 **/
	virtual void load() = 0;
	/**
	 * Reset all settings to their default values.
	 **/
	virtual void defaults() = 0;

protected Q_SLOTS:
	/**
	 * Calling this slot is equivalent to emitting changed(true).
	 **/
	void changed();
}; // END class PreferencesPage

} // END namespace Noatun

#endif // N_PREFERENCESPAGE_H
