/*
 * newsiconmgr.h
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef NEWSICONMGR_H
#define NEWSICONMGR_H

#include <qobject.h>
#include <qpixmap.h>

#include <kio/job.h>
#include <kurl.h>

class QDBusInterface;

struct KIODownload
{
	KUrl       url;
	QByteArray data;
	qint64 dataOffset;
};

typedef QMap<KJob *, KIODownload> KIODownloadMap;

class NewsIconMgr : public QObject
{
	Q_OBJECT
        Q_CLASSINFO("D-Bus Interface", "org.kde.knewsticker.newsiconmgr")

	public:
		static NewsIconMgr *self();
	
		void getIcon(const KUrl &);
		bool isStdIcon(const QPixmap &) const;
	
	public Q_SLOTS:
		Q_SCRIPTABLE void slotGotIcon(bool, QString, QString);
	
	signals:
		void gotIcon(const KUrl &, const QPixmap &);
	
	protected:
		NewsIconMgr(QObject * = 0L, const char * = 0L);
		~NewsIconMgr();
		
	private slots:
		void slotData(KIO::Job *, const QByteArray &);
		void slotResult(KJob *);

	private:
		QString favicon(const KUrl &) const;

		QPixmap        m_stdIcon;
		KIODownloadMap m_kioDownload;

		static NewsIconMgr *m_instance;
		QDBusInterface *m_favIconsModule;
};

#endif // NEWSICONMGR_H
