/*
  KPF - Public fileserver for KDE

  Copyright 2001 Rik Hemsley (rikkus) <rik@kde.org>

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to
  deal in the Software without restriction, including without limitation the
  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
  sell copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ErrorMessageConfigDialog.h"
#include "ErrorMessageConfigDialog.moc"

#include <qlabel.h>
#include <q3frame.h>
#include <qlayout.h>
//Added by qt3to4:
#include <QVBoxLayout>
#include <QGridLayout>

#include <kurlrequester.h>
#include <kconfig.h>
#include <klocale.h>
#include <kdialog.h>

#include "Defines.h"
#include "Defaults.h"
#include "Utils.h"

namespace KPF
{
  ErrorMessageConfigDialog::ErrorMessageConfigDialog
  (
   WebServer  * webServer,
   QWidget    * parent
  )
    : KDialog
    (
     parent
    ),
    server_(webServer)
  {
    setCaption(i18n("Configure error messages"));
    setButtons(KDialog::Ok | KDialog::Cancel);
    setDefaultButton(KDialog::Cancel);
    setModal(false);
    showButtonSeparator(true);

    QList<uint> codeList;

    codeList << 400 << 403 << 404 << 412 << 416 << 500 << 501;

    QFrame * w = new QFrame(this);
    setMainWidget(w);

    QVBoxLayout * layout = new QVBoxLayout(w );
    layout->setMargin( KDialog::marginHint() );
    layout->setSpacing( KDialog::spacingHint() );

    QLabel * info =
      new QLabel
      (
       i18n
       (
        "<p>Here you may select files to use instead of the default error"
        " messages passed to a client.</p>"
        "<p>The files may contain anything you wish, but by convention"
        " you should report the error code and the English version of"
        " the error message (e.g. \"Bad request\"). Your file should"
        " also be valid HTML.</p>"
        "<p>The strings ERROR_MESSAGE, ERROR_CODE and RESOURCE, if"
        " they exist in the file, will be replaced with the English"
        " error message, the numeric error code and the path of the"
        " requested resource, respectively.</p>"
       ),
       w
      );

    layout->addWidget(info);

    QGridLayout * grid = new QGridLayout();
    layout->addItem( grid );

    KConfig config(Config::name());

    config.setGroup("ErrorMessageOverrideFiles");

    QList<uint>::ConstIterator it;

    for (it = codeList.begin(); it != codeList.end(); ++it)
    {
      QString originalPath =
        config.readPathEntry(QString::number(*it));

      QString responseName(translatedResponseName(*it));

      KUrlRequester * requester = new KUrlRequester(originalPath, w);

      itemList_.append(new Item(*it, requester, responseName, originalPath));

      QLabel * l = new QLabel(i18n("%1 %2", *it, responseName), w);

      l->setBuddy(requester);

      grid->addWidget(l,          *it, 0);
      grid->addWidget(requester,  *it, 1);
    }
  }

  ErrorMessageConfigDialog::~ErrorMessageConfigDialog()
  {
    itemList_.setAutoDelete(true);
    itemList_.clear();
  }

    void
  ErrorMessageConfigDialog::slotURLRequesterTextChanged(const QString &)
  {
  }

    void
  ErrorMessageConfigDialog::accept()
  {
    KConfig config(Config::name());

    config.setGroup("ErrorMessageOverrideFiles");

    Q3PtrListIterator<Item> it(itemList_);

    for (; it.current(); ++it)
    {
      config.writePathEntry
        (
         QString::number(it.current()->code),
         it.current()->urlRequester->url()
        );
    }

    config.sync();

    KDialog::accept();
  }
}

// vim:ts=2:sw=2:tw=78:et
