/***************************************************************************
                          stuff.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_wireless.h"
#include <QDir>
#include <QFile>
#include <QString>
#include <QStringList>
#include <QColor>
#include <QRegExp>

#ifndef WITHOUT_ARTS
#include <arts/artsflow.h>
#include <arts/connect.h>
#include <arts/iomanager.h>
#include <arts/referenceclean.h>
#endif // WITHOUT_ARTS

#include <iostream>
#include <string>
#include <klocale.h>
#include <kprocio.h>
#include <kdebug.h>
#include <arpa/inet.h>

QStringList Interface_wireless::ignoreInterfaces;

Interface_wireless::Interface_wireless ( )
{
  has_frequency = false;
  frequency = 0;
  has_mode = false;
  mode = 0;
  has_key = 0;
  key = "";
  key_size = 0;
  key_flags = 0;
  essid = "";
  access_point_address = "";
  ip_addresses.clear (  );
  bitrate = 0;
  socket = -1;
  has_range = false;
  for ( int i = 0; i < MAX_HISTORY; i++ )
    {
      sigLevel[i] = -255;
      noiseLevel[i] = -255;
      qual[i] = -255;
      valid[i] = false;
    }
  current = 0;
  sigLevelMin = 32000;
  noiseLevelMin = 32000;
  sigLevelMax = -32000;
  noiseLevelMax = -32000;

  already_warned = false;
}

bool
Interface_wireless::get_device_freq ( long &freq )
{
  if ( has_frequency )
    {
      freq = frequency;
      return true;
    }
  else
    {
      return false;
    }
}

bool
Interface_wireless::get_mode ( int &ext_mode )
{
  if ( has_mode )
    {
      ext_mode = mode;
      return true;
    }
  else
    {
      return false;
    }
}

bool
Interface_wireless::get_key ( QString & ext_key, int &ext_size, int &ext_flags )
{
  if ( has_key )
    {
      ext_key = key;
      ext_size = key_size;
      ext_flags = key_flags;
      return true;
    }
  else
    {
      return false;
    }
}

QString
Interface_wireless::get_essid (  )
{
  return essid;
}

bool
Interface_wireless::get_has_txpower (  )
{
  return has_txpower;
}

int
Interface_wireless::get_txpower_disabled (  )
{
  return txpower_disabled;
}

bool
Interface_wireless::get_AP_info ( QString & mac, QString & /*ip */  )
{
  mac = access_point_address;
  return false;
}

QStringList
Interface_wireless::get_IP_info (  )
{
  return ip_addresses;
}

signed long
Interface_wireless::get_bitrate (  )
{
  return bitrate;
}

signed long
Interface_wireless::getMaxBitrate (  )
{
  return maxBitrate;
}

QString
Interface_wireless::get_interface_name (  )
{
  return interface_name;
}

bool
Interface_wireless::get_current_quality ( int &sig, int &noi, int &qua )
{
  if ( valid[current] )
    {
      sig = sigLevel[current];
      noi = noiseLevel[current];
      qua = qual[current];
      return true;
    }
  else
    return false;
}

CARDSTATES
Interface_wireless::getDeviceState (  )
{
  if ( !has_frequency || txpower_disabled )
    {
      return NO_CARD;
    }
  else if ( mode == 1 )
    {
      return AD_HOC;
    }
  else if ( qual[current] == 0 )
    {
      return NO_CONNECTION;
    }
  else if ( qual[current] > 0 )
    {
      return AP_CONNECT;
    }
  else
    return NO_CARD;
}

#ifndef WITHOUT_ARTS

void
sine_wave ( double frequency )
{
  using namespace Arts;
  StdIOManager *limiter = new StdIOManager;
  Dispatcher dispatcher ( limiter );
  MyTimeNotify *zeit = new MyTimeNotify ( &dispatcher );
  Synth_FREQUENCY freq;
  Synth_WAVE_SIN sin;
  Synth_PLAY play;
  setValue ( freq, frequency );
  connect ( freq, sin );
  connect ( sin, play, "invalue_left" );
  freq.start (  );
  sin.start (  );
  play.start (  );
  limiter->addTimer ( 240, zeit );
  dispatcher.run (  );
  play.stop (  );
  sin.stop (  );
  freq.stop (  );
}

void
MyTimeNotify::notifyTime (  )
{
  test->terminate (  );
}

#endif

QString
whois ( const char *MAC_ADR, QStringList APList )
{
  for ( QStringList::Iterator it = APList.begin (  ); it != APList.end (  ); ( it++ )++ )
    {
      if ( ( *it ) == ( QString ) MAC_ADR )
	return *( ++it );
    }
  return i18n ( "UNKNOWN" );
}

int
NetworkParameterDataModel::rowCount ( const QModelIndex & parent ) const 
{
  return dataContainer.size (  );
}

int
NetworkParameterDataModel::columnCount ( const QModelIndex & parent ) const
{
  return 4;
}

QVariant
NetworkParameterDataModel::data ( const QModelIndex & index, int role ) const
{
  if ( index.row (  ) >= dataContainer.size (  ) )
    return QVariant (  );

  if ( role != Qt::DisplayRole && role != Qt::BackgroundColorRole )
    return QVariant (  );

  if ( role == Qt::DisplayRole )
    switch ( index.column (  ) )
      {
      case 0:
	return dataContainer[index.row (  )].ssid;
      case 1:
	return dataContainer[index.row (  )].mode;
      case 2:
	return ( QString ( "%1" ) ).arg ( dataContainer[index.row (  )].quality );
      case 3:
	if ( dataContainer[index.row (  )].encryption == "off" )
	  return QString ( i18n ( "off" ) );
	if ( dataContainer[index.row (  )].encryption == "on" )
	  return QString ( i18n ( "on" ) );
	return dataContainer[index.row (  )].encryption;
      default:
	return QVariant (  );
      }

  if ( role == Qt::BackgroundColorRole )
    switch ( index.column (  ) )
      {
      case 0:
	return ( dataContainer[index.row (  )].ssid == "" ? QColor ( 255, 255, 0 ) : QColor ( 0, 128, 0 ) );
      case 1:
	return QColor ( 0, 128, 0 );
      case 2:
	return QColor ( 0, 128, 0 );
      case 3:
	if ( dataContainer[index.row (  )].encryption == "on" )
	  return QColor ( 255, 255, 0 );
	if ( checkWEP ( dataContainer[index.row (  )].encryption ) == NONE )
	  return QColor ( 0, 128, 0 );
	if ( checkWEP ( dataContainer[index.row (  )].encryption ) == VALID_HEX ||
	     checkWEP ( dataContainer[index.row (  )].encryption ) == VALID_STRING )
	  return QColor ( 0, 128, 0 );
	if ( checkWEP ( dataContainer[index.row (  )].encryption ) == INVALID )
	  return QColor ( 255, 0, 0 );
	return QVariant (  );
      default:
	return QVariant (  );
      }

  // we will never get here, but let's make the compiler happy
  return QVariant ();
}

WEP_KEY
NetworkParameterDataModel::checkWEP ( const QString & key ) const 
{

  kDebug (  ) << "In checkWEP()\n";
  if ( key == "off" )
    return NONE;

  if ( key.length (  ) == 5 )
    return VALID_STRING;
  if ( key.length (  ) == 13 )
    return VALID_STRING;
  if ( key.length (  ) == 32 )
    return VALID_STRING;

  // a more restrictive check: is it really a hex number?

  QRegExp hexNumber ( "[A-F,a-f,0-9]*" );

  if ( key.length (  ) == 10 && hexNumber.exactMatch ( key ) )
    return VALID_HEX;
  if ( key.length (  ) == 26 && hexNumber.exactMatch ( key ) )
    return VALID_HEX;
  if ( key.length (  ) == 64 && hexNumber.exactMatch ( key ) )
    return VALID_HEX;

  return INVALID;
}


QVariant
NetworkParameterDataModel::data ( int row, int col )
{
  return data ( createIndex ( row, col, 0 ), Qt::DisplayRole );
}

QVariant
NetworkParameterDataModel::headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const
{
  if ( orientation == Qt::Vertical )
    return QVariant (  );
  switch ( section )
    {
    case 0:
      return i18n ( "SSID" );
      break;
    case 1:
      return i18n ( "Mode" );
      break;
    case 2:
      return i18n ( "Quality" );
      break;
    case 3:
      return i18n ( "Encryption" );
      break;
    case 4:
      return "reserved";
      break;
    default:
      return "???";
      break;
    }
}

QVariant
NetworkParameterDataModel::headerData ( int col )
{
  return headerData ( col, Qt::Horizontal );
}

bool
NetworkParameterDataModel::setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole )
{
  if ( role != Qt::EditRole )
    return false;
  if ( dataContainer.size (  ) == 0 )
    insertColumns ( 0, 4 );
  for ( int i = dataContainer.size (  ); i <= index.row (  ); i++ )
    {
      kDebug (  ) << "intialising intermediate row " << i << ".\n";
      struct NetworkParameterData *newRow = new NetworkParameterData;
      newRow->ssid = "";
      newRow->mode = "";
      newRow->quality = 0;
      newRow->encryption = "off";
      dataContainer.append ( *newRow );
      insertRow ( i );
    }
  kDebug (  ) << "Setting value at row " << index.row (  ) << ", col " << index.column (  ) << " to " << value.
    toString (  ) << ".\n";

  switch ( index.column (  ) )
    {
    case 0:
      dataContainer[index.row (  )].ssid = value.toString (  );
      break;
    case 1:
      dataContainer[index.row (  )].mode = value.toString (  );
      break;
    case 2:
      dataContainer[index.row (  )].quality = value.toString (  ).toInt (  );
      break;
    case 3:
      dataContainer[index.row (  )].encryption = value.toString (  );
      break;
    default:
      return false;
    }
  // emit dataChanged(index,index);       
  return true;
}

void
NetworkParameterDataModel::gotFinishedIndicator (  )
{
  emit finishedScanning (  );
}

bool
NetworkParameterDataModel::setData ( int row, int col, const QVariant & value )
{
  return setData ( createIndex ( row, col ), value );
}

Qt::ItemFlags NetworkParameterDataModel::flags ( const QModelIndex & index ) const
{
  if ( index.row (  ) >= dataContainer.size (  ) )
    return 0;
  if ( index.column (  ) > 3 )
    return 0;
  if ( index.column (  ) != 0 && index.column (  ) != 3 )
    return Qt::ItemIsSelectable;
  if ( index.column (  ) == 0 && !dataContainer[index.row (  )].ssid.isEmpty() )
    return Qt::ItemIsSelectable;
  if ( index.column (  ) == 3 && dataContainer[index.row (  )].encryption == "off" )
    return Qt::ItemIsSelectable;
  return Qt::ItemIsSelectable | Qt::ItemIsEnabled | Qt::ItemIsEditable;
}

#include "interface_wireless.moc"
