/***************************************************************************
                          stuff.h  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIRELESS_H
#define INTERFACE_WIRELESS_H

#include "config-wifi.h"

#include <QObject>
#include <QString>
#include <QStringList>
#include <QAbstractTableModel>
#include <QVarLengthArray>

#ifndef WITHOUT_ARTS
#include <arts/iomanager.h>
#include <arts/dispatcher.h>
#endif

const int POLL_DELAY_MS = 250;	// how much time between device polls
const int MAX_HISTORY = 240;	// number of device states to be saved

enum CARDSTATES
{ NO_CARD, NO_CONNECTION, AD_HOC, AP_CONNECT };
enum WEP_KEY
{ NONE, VALID_HEX, VALID_STRING, INVALID };

struct NetworkParameterData
{
  QString ssid;
  QString mode;
  int quality;
  QString encryption;
};

class NetworkParameterDataModel:public QAbstractTableModel
{
Q_OBJECT public:
  int rowCount ( const QModelIndex & parent ) const;
  int columnCount ( const QModelIndex & parent ) const;
  QVariant data ( const QModelIndex & index, int role ) const;
  QVariant data ( int row, int col );
  QVariant headerData ( int section, Qt::Orientation orientation, int role ) const;
  QVariant headerData ( int row );
  bool setData ( const QModelIndex & index, const QVariant & value, int role );
  bool setData ( int row, int col, const QVariant & value );
    Qt::ItemFlags flags ( const QModelIndex & index ) const;
  public slots:void gotFinishedIndicator (  );
    signals:void finishedScanning (  );
protected:
    QVarLengthArray < struct NetworkParameterData >dataContainer;
  WEP_KEY checkWEP ( const QString & key ) const;
};

class Interface_wireless:public QObject
{
Q_OBJECT public:
    Interface_wireless ( );
    virtual ~ Interface_wireless (  )
  {
  };

  virtual bool get_device_freq ( long &freq );
  // true: device returned valid frequency (frequency in MEGAHertz)
  virtual bool get_mode ( int &mode );
  // true: device returned valid mode info
  virtual bool get_key ( QString & key, int &size, int &flags );
  // true: device has set up a valid crypto key
  virtual QString get_essid (  );
  virtual bool get_AP_info ( QString & mac, QString & ip );
  // true: could retrieve IP, false: returned IP info invalid
  virtual QStringList get_IP_info (  );
  virtual signed long get_bitrate (  );
  virtual QString get_interface_name (  );
  // if no device is attached, return empty QString
  virtual bool get_current_quality ( int &sig, int &noi, int &qua );
  // quality info is only valid when true
  virtual long toggleFreqChannel ( long input ) = 0;
  // converts frequency <-> channel, frequency in MEGAHertz
  virtual NetworkParameterDataModel *get_available_networks (  ) = 0;
  virtual bool get_has_txpower (  );
  virtual int get_txpower_disabled (  );
  virtual CARDSTATES getDeviceState (  );
  virtual void setActiveDevice ( QString device ) = 0;
  virtual signed long getMaxBitrate (  );
  // stats
  int sigLevel[MAX_HISTORY];
  int sigLevelMin, sigLevelMax;
  int noiseLevel[MAX_HISTORY];
  int noiseLevelMin, noiseLevelMax;
  int qual[MAX_HISTORY];
  bool valid[MAX_HISTORY];
  int current;

  public slots:virtual bool poll_device_info (  ) = 0;

signals:
  void notifyInterfaceChanged ( );
  void strengthChanged ( int, int, int );
  void statusChanged (  );
  void modeChanged ( CARDSTATES );
  void speedChanged ( signed long );
  void essidChanged ( QString );
  void txPowerChanged (  );
  void statsUpdated (  );
protected:
  bool already_warned;
  // device info
  bool has_frequency;
  long frequency;
  bool has_mode;
  int mode;
  bool has_key;
  QString key;
  int key_size;
  int key_flags;
  QString essid;
  QString access_point_address;
  QStringList ip_addresses;
  signed long bitrate;
  signed long maxBitrate;
  QString interface_name;
  int socket;
  bool has_range;
  int max_quality;
  static QStringList ignoreInterfaces;
  bool has_txpower;
  int txpower_disabled;
  NetworkParameterDataModel *networks;
};

#ifndef WITHOUT_ARTS

void sinus_wave ( double frequency );

class MyTimeNotify:public
  Arts::TimeNotify
{
public:
  Arts::Dispatcher * test;
  MyTimeNotify ( Arts::Dispatcher * siff )
  {
    test = siff;
  };
  void notifyTime (  );
};

#endif

QString whois ( const char *MAC_ADR, QStringList APList );

#endif /*  INTERFACE_WIRELESS_H */
